/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.pipeline.transform.transformer;

import io.github.douira.glsl_transformer.ast.node.TranslationUnit;
import io.github.douira.glsl_transformer.ast.query.Root;
import io.github.douira.glsl_transformer.ast.transform.ASTParser;
import net.irisshaders.iris.compat.embeddium.impl.monocle.EmbeddiumParameters;
import net.irisshaders.iris.pipeline.transform.PatchShaderType;
import net.irisshaders.iris.pipeline.transform.transformer.EmbeddiumTransformer;

public class EmbeddiumCoreTransformer {
    public static void transform(ASTParser t, TranslationUnit tree, Root root, EmbeddiumParameters parameters) {
        root.rename("alphaTestRef", "iris_currentAlphaTest");
        root.rename("modelViewMatrix", "iris_ModelViewMatrix");
        root.rename("modelViewMatrixInverse", "iris_ModelViewMatrixInverse");
        root.rename("projectionMatrix", "iris_ProjectionMatrix");
        root.rename("projectionMatrixInverse", "iris_ProjectionMatrixInverse");
        root.rename("normalMatrix", "iris_NormalMatrix");
        root.rename("chunkOffset", "u_RegionOffset");
        if (parameters.type == PatchShaderType.VERTEX) {
            boolean needsNormal = root.identifierIndex.has("vaNormal") || root.identifierIndex.has("at_tangent");
            root.replaceReferenceExpressions(t, "vaPosition", "_vert_position + _get_draw_translation(_draw_id)");
            root.replaceReferenceExpressions(t, "vaColor", "_vert_color");
            root.replaceReferenceExpressions(t, "vaNormal", "irs_Normal");
            root.replaceReferenceExpressions(t, "at_tangent", "irs_Tangent");
            root.replaceReferenceExpressions(t, "vaUV0", "_vert_tex_diffuse_coord");
            root.replaceReferenceExpressions(t, "vaUV1", "ivec2(0, 10)");
            root.replaceReferenceExpressions(t, "vaUV2", "a_LightAndData.xy");
            root.replaceReferenceExpressions(t, "textureMatrix", "mat4(1.0)");
            EmbeddiumTransformer.replaceMidTexCoord(t, tree, root, 3.0517578E-5f);
            EmbeddiumTransformer.replaceMCEntity(t, tree, root);
            EmbeddiumTransformer.injectVertInit(t, tree, root, parameters, needsNormal);
        }
    }
}

