/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.compat.embeddium.mixin.monocle.mixin;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.api.v0.IrisApi;
import net.irisshaders.iris.compat.embeddium.impl.oculus.vertices.CloudVertex;
import net.irisshaders.iris.pipeline.ShaderRenderingPipeline;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.irisshaders.iris.pipeline.programs.ShaderKey;
import net.irisshaders.iris.vertices.IrisVertexFormats;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.world.phys.Vec3;
import org.embeddedt.embeddium.api.vertex.format.VertexFormatDescription;
import org.embeddedt.embeddium.api.vertex.format.common.ColorVertex;
import org.embeddedt.embeddium.impl.render.immediate.CloudRenderer;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CloudRenderer.class})
public abstract class MixinCloudRenderer {
    @Shadow
    private ShaderInstance shader;
    @Shadow
    @Final
    private FogRenderer.FogData fogData;
    @Shadow
    private boolean hasCloudGeometry;
    @Unique
    private VertexBuffer vertexBufferWithNormals;
    @Unique
    private int prevCenterCellXIris;
    @Unique
    private int prevCenterCellYIris;
    @Unique
    private int cachedRenderDistanceIris;

    @Inject(method={"writeVertex"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void writeIrisVertex(long buffer, float x, float y, float z, int color, CallbackInfoReturnable<Long> cir) {
        if (IrisApi.getInstance().isShaderPackInUse()) {
            CloudVertex.write(buffer, x, y, z, color);
            cir.setReturnValue((Object)(buffer + 20L));
        }
    }

    @Shadow
    protected abstract void rebuildGeometry(BufferBuilder var1, int var2, int var3, int var4);

    @Shadow
    protected abstract void applyFogModifiers(ClientLevel var1, FogRenderer.FogData var2, LocalPlayer var3, int var4, float var5);

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void buildIrisVertexBuffer(ClientLevel world, LocalPlayer player, PoseStack stack, Matrix4f modelViewMatrix, Matrix4f projectionMatrix, float ticks, float tickDelta, double cameraX, double cameraY, double cameraZ, CallbackInfo ci) {
        if (IrisApi.getInstance().isShaderPackInUse()) {
            ci.cancel();
            this.renderIris(world, player, modelViewMatrix, projectionMatrix, ticks, tickDelta, cameraX, cameraY, cameraZ);
        }
    }

    public void renderIris(@Nullable ClientLevel world, LocalPlayer player, Matrix4f modelViewMatrix, Matrix4f projectionMatrix, float ticks, float tickDelta, double cameraX, double cameraY, double cameraZ) {
        boolean insideClouds;
        if (world == null) {
            return;
        }
        float cloudHeight = world.effects().getCloudHeight();
        if (Float.isNaN(cloudHeight)) {
            return;
        }
        Vec3 color = world.getCloudColor(tickDelta);
        double cloudTime = (ticks + tickDelta) * 0.03f;
        double cloudCenterX = cameraX + cloudTime;
        double cloudCenterZ = cameraZ + 0.33;
        int renderDistance = Minecraft.getInstance().options.getEffectiveRenderDistance();
        int cloudDistance = Math.max(32, renderDistance * 2 + 9);
        int centerCellX = (int)Math.floor(cloudCenterX / 12.0);
        int centerCellZ = (int)Math.floor(cloudCenterZ / 12.0);
        if (this.vertexBufferWithNormals == null || this.prevCenterCellXIris != centerCellX || this.prevCenterCellYIris != centerCellZ || this.cachedRenderDistanceIris != renderDistance) {
            BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, IrisVertexFormats.CLOUDS);
            this.rebuildGeometry(bufferBuilder, cloudDistance + 4, centerCellX, centerCellZ);
            if (this.vertexBufferWithNormals == null) {
                this.vertexBufferWithNormals = new VertexBuffer(VertexBuffer.Usage.DYNAMIC);
            }
            this.vertexBufferWithNormals.bind();
            MeshData meshData = bufferBuilder.build();
            if (meshData != null) {
                this.vertexBufferWithNormals.upload(meshData);
                this.hasCloudGeometry = true;
            } else {
                this.hasCloudGeometry = false;
            }
            VertexBuffer.unbind();
            this.prevCenterCellXIris = centerCellX;
            this.prevCenterCellYIris = centerCellZ;
            this.cachedRenderDistanceIris = renderDistance;
        }
        if (!this.hasCloudGeometry) {
            return;
        }
        float previousEnd = RenderSystem.getShaderFogEnd();
        float previousStart = RenderSystem.getShaderFogStart();
        this.fogData.end = cloudDistance * 8;
        this.fogData.start = cloudDistance * 8 - 16;
        this.applyFogModifiers(world, this.fogData, player, cloudDistance * 8, tickDelta);
        RenderSystem.setShaderFogEnd((float)this.fogData.end);
        RenderSystem.setShaderFogStart((float)this.fogData.start);
        float translateX = (float)(cloudCenterX - (double)(centerCellX * 12));
        float translateZ = (float)(cloudCenterZ - (double)(centerCellZ * 12));
        RenderSystem.enableDepthTest();
        this.vertexBufferWithNormals.bind();
        boolean bl = insideClouds = cameraY < (double)(cloudHeight + 4.5f) && cameraY > (double)(cloudHeight - 0.5f);
        if (insideClouds) {
            RenderSystem.disableCull();
        } else {
            RenderSystem.enableCull();
        }
        RenderSystem.setShaderColor((float)((float)color.x), (float)((float)color.y), (float)((float)color.z), (float)0.8f);
        modelViewMatrix = new Matrix4f((Matrix4fc)modelViewMatrix);
        modelViewMatrix.translate(-translateX, cloudHeight - (float)cameraY + 0.33f, -translateZ);
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        this.vertexBufferWithNormals.drawWithShader(modelViewMatrix, projectionMatrix, this.getClouds());
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)514);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        this.vertexBufferWithNormals.drawWithShader(modelViewMatrix, projectionMatrix, this.getClouds());
        VertexBuffer.unbind();
        RenderSystem.disableBlend();
        RenderSystem.depthFunc((int)515);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableCull();
        RenderSystem.setShaderFogEnd((float)previousEnd);
        RenderSystem.setShaderFogStart((float)previousStart);
    }

    @ModifyArg(method={"rebuildGeometry"}, at=@At(value="INVOKE", target="Lorg/lwjgl/system/MemoryStack;nmalloc(I)J"), remap=false)
    private int allocateNewSize(int size) {
        return IrisApi.getInstance().isShaderPackInUse() ? 480 : size;
    }

    @ModifyArg(method={"rebuildGeometry"}, at=@At(value="INVOKE", target="Lorg/embeddedt/embeddium/api/vertex/buffer/VertexBufferWriter;push(Lorg/lwjgl/system/MemoryStack;JILorg/embeddedt/embeddium/api/vertex/format/VertexFormatDescription;)V"), index=3, remap=false)
    private VertexFormatDescription modifyArgIris(VertexFormatDescription vertexFormatDescription) {
        if (IrisApi.getInstance().isShaderPackInUse()) {
            return CloudVertex.FORMAT;
        }
        return ColorVertex.FORMAT;
    }

    private ShaderInstance getClouds() {
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
        if (pipeline instanceof ShaderRenderingPipeline) {
            return ((ShaderRenderingPipeline)pipeline).getShaderMap().getShader(ShaderKey.CLOUDS_SODIUM);
        }
        return this.shader;
    }
}

