/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.compat.embeddium.impl.oculus;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.irisshaders.iris.compat.embeddium.impl.oculus.EmbeddiumPrograms;
import net.irisshaders.iris.compat.embeddium.impl.oculus.GlUniformMatrix3f;
import net.irisshaders.iris.gl.IrisRenderSystem;
import net.irisshaders.iris.gl.blending.BlendModeOverride;
import net.irisshaders.iris.gl.blending.BufferBlendOverride;
import net.irisshaders.iris.gl.program.ProgramImages;
import net.irisshaders.iris.gl.program.ProgramSamplers;
import net.irisshaders.iris.gl.program.ProgramUniforms;
import net.irisshaders.iris.gl.state.FogMode;
import net.irisshaders.iris.pipeline.IrisRenderingPipeline;
import net.irisshaders.iris.samplers.IrisSamplers;
import net.irisshaders.iris.uniforms.CapturedRenderingState;
import net.irisshaders.iris.uniforms.CommonUniforms;
import net.irisshaders.iris.uniforms.builtin.BuiltinReplacementUniforms;
import net.irisshaders.iris.uniforms.custom.CustomUniforms;
import net.irisshaders.iris.vertices.ImmediateState;
import net.minecraft.client.Minecraft;
import org.embeddedt.embeddium.impl.gl.shader.uniform.GlUniformFloat3v;
import org.embeddedt.embeddium.impl.gl.shader.uniform.GlUniformMatrix4f;
import org.embeddedt.embeddium.impl.render.chunk.shader.ChunkFogMode;
import org.embeddedt.embeddium.impl.render.chunk.shader.ChunkShaderInterface;
import org.embeddedt.embeddium.impl.render.chunk.shader.ChunkShaderOptions;
import org.embeddedt.embeddium.impl.render.chunk.shader.ShaderBindingContext;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class EmbeddiumShader
extends ChunkShaderInterface {
    private GlUniformMatrix4f uniformModelViewMatrix;
    private GlUniformMatrix4f uniformModelViewMatrixInv;
    private GlUniformMatrix4f uniformProjectionMatrix;
    private GlUniformMatrix4f uniformProjectionMatrixInv;
    private GlUniformMatrix3f uniformNormalMatrix;
    private GlUniformFloat3v uniformRegionOffset;
    private final ProgramImages images;
    private final ProgramSamplers samplers;
    private final ProgramUniforms uniforms;
    private final CustomUniforms customUniforms;
    private final BlendModeOverride blendModeOverride;
    private final List<BufferBlendOverride> bufferBlendOverrides;
    private final float alphaTest;
    private final boolean containsTessellation;
    public static final ChunkShaderOptions OPTS = new ChunkShaderOptions(ChunkFogMode.NONE, null, null);

    public EmbeddiumShader(IrisRenderingPipeline pipeline, EmbeddiumPrograms.Pass pass, ShaderBindingContext context, int handle, BlendModeOverride blendModeOverride, List<BufferBlendOverride> bufferBlendOverrides, CustomUniforms customUniforms, Supplier<ImmutableSet<Integer>> flipState, float alphaTest, boolean containsTessellation) {
        super(context, OPTS);
        try {
            this.uniformModelViewMatrix = (GlUniformMatrix4f)context.bindUniform("iris_ModelViewMatrix", GlUniformMatrix4f::new);
        }
        catch (Exception e) {
            this.uniformModelViewMatrix = null;
        }
        try {
            this.uniformModelViewMatrixInv = (GlUniformMatrix4f)context.bindUniform("iris_ModelViewMatrixInverse", GlUniformMatrix4f::new);
        }
        catch (Exception e) {
            this.uniformModelViewMatrixInv = null;
        }
        try {
            this.uniformNormalMatrix = (GlUniformMatrix3f)context.bindUniform("iris_NormalMatrix", GlUniformMatrix3f::new);
        }
        catch (Exception e) {
            this.uniformNormalMatrix = null;
        }
        try {
            this.uniformProjectionMatrix = (GlUniformMatrix4f)context.bindUniform("iris_ProjectionMatrix", GlUniformMatrix4f::new);
        }
        catch (Exception e) {
            this.uniformProjectionMatrix = null;
        }
        try {
            this.uniformProjectionMatrixInv = (GlUniformMatrix4f)context.bindUniform("iris_ProjectionMatrixInv", GlUniformMatrix4f::new);
        }
        catch (Exception e) {
            this.uniformProjectionMatrixInv = null;
        }
        try {
            this.uniformRegionOffset = (GlUniformFloat3v)context.bindUniform("u_RegionOffset", GlUniformFloat3v::new);
        }
        catch (Exception e) {
            this.uniformRegionOffset = null;
        }
        this.alphaTest = alphaTest;
        this.containsTessellation = containsTessellation;
        boolean isShadowPass = pass == EmbeddiumPrograms.Pass.SHADOW || pass == EmbeddiumPrograms.Pass.SHADOW_CUTOUT;
        this.uniforms = this.buildUniforms(pass, handle, customUniforms);
        this.customUniforms = customUniforms;
        this.samplers = this.buildSamplers(pipeline, pass, handle, isShadowPass, flipState);
        this.images = this.buildImages(pipeline, pass, handle, isShadowPass, flipState);
        this.blendModeOverride = blendModeOverride;
        this.bufferBlendOverrides = bufferBlendOverrides;
    }

    private ProgramUniforms buildUniforms(EmbeddiumPrograms.Pass pass, int handle, CustomUniforms customUniforms) {
        ProgramUniforms.Builder builder = ProgramUniforms.builder(pass.name().toLowerCase(Locale.ROOT), handle);
        CommonUniforms.addDynamicUniforms(builder, FogMode.PER_VERTEX);
        customUniforms.assignTo(builder);
        BuiltinReplacementUniforms.addBuiltinReplacementUniforms(builder);
        customUniforms.mapholderToPass(builder, (Object)this);
        return builder.buildUniforms();
    }

    private ProgramSamplers buildSamplers(IrisRenderingPipeline pipeline, EmbeddiumPrograms.Pass pass, int handle, boolean isShadowPass, Supplier<ImmutableSet<Integer>> flipState) {
        ProgramSamplers.Builder builder = ProgramSamplers.builder(handle, IrisSamplers.SODIUM_RESERVED_TEXTURE_UNITS);
        pipeline.addGbufferOrShadowSamplers(builder, ProgramImages.builder(handle), flipState, isShadowPass, true, true, false);
        return builder.build();
    }

    private ProgramImages buildImages(IrisRenderingPipeline pipeline, EmbeddiumPrograms.Pass pass, int handle, boolean isShadowPass, Supplier<ImmutableSet<Integer>> flipState) {
        ProgramImages.Builder builder = ProgramImages.builder(handle);
        pipeline.addGbufferOrShadowSamplers(ProgramSamplers.builder(handle, IrisSamplers.SODIUM_RESERVED_TEXTURE_UNITS), builder, flipState, isShadowPass, true, true, false);
        return builder.build();
    }

    public void setRegionOffset(float x, float y, float z) {
        if (this.uniformRegionOffset != null) {
            this.uniformRegionOffset.set(x, y, z);
        }
    }

    public void setModelViewMatrix(Matrix4fc matrix) {
        if (this.uniformModelViewMatrix != null) {
            this.uniformModelViewMatrix.set(matrix);
        }
        Matrix4f invertedMatrix = matrix.invert(new Matrix4f());
        if (this.uniformModelViewMatrixInv != null) {
            this.uniformModelViewMatrixInv.set((Matrix4fc)invertedMatrix);
        }
        if (this.uniformNormalMatrix != null) {
            Matrix3f normalMatrix = invertedMatrix.transpose3x3(new Matrix3f());
            this.uniformNormalMatrix.set((Matrix3fc)normalMatrix);
        }
    }

    public void setProjectionMatrix(Matrix4fc matrix) {
        if (this.uniformProjectionMatrix != null) {
            this.uniformProjectionMatrix.set(matrix);
        }
        if (this.uniformProjectionMatrixInv != null) {
            Matrix4f invertedMatrix = matrix.invert(new Matrix4f());
            this.uniformProjectionMatrixInv.set((Matrix4fc)invertedMatrix);
        }
    }

    public void setupState() {
        this.applyBlendModes();
        this.updateUniforms();
        this.images.update();
        this.bindTextures();
        if (this.containsTessellation) {
            ImmediateState.usingTessellation = true;
        }
    }

    private void bindTextures() {
        IrisRenderSystem.bindTextureToUnit(3553, 0, RenderSystem.getShaderTexture((int)0));
        IrisRenderSystem.bindTextureToUnit(3553, 2, RenderSystem.getShaderTexture((int)2));
        GlStateManager._activeTexture((int)33986);
    }

    private void applyBlendModes() {
        if (this.blendModeOverride != null) {
            this.blendModeOverride.apply();
        }
        this.bufferBlendOverrides.forEach(BufferBlendOverride::apply);
    }

    private void updateUniforms() {
        CapturedRenderingState.INSTANCE.setCurrentAlphaTest(this.alphaTest);
        this.samplers.update();
        this.uniforms.update();
        this.customUniforms.push((Object)this);
    }

    public void resetState() {
        ProgramUniforms.clearActiveUniforms();
        ProgramSamplers.clearActiveSamplers();
        BlendModeOverride.restore();
        Minecraft.getInstance().getMainRenderTarget().bindWrite(false);
        ImmediateState.usingTessellation = false;
    }
}

