/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.compat.embeddium.impl.monocle;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.compat.embeddium.impl.monocle.CompTransformer;
import net.irisshaders.iris.compat.embeddium.impl.monocle.EmbeddiumParameters;
import net.irisshaders.iris.compat.embeddium.impl.monocle.TextureTransformer;
import net.irisshaders.iris.gl.blending.AlphaTest;
import net.irisshaders.iris.gl.shader.ShaderType;
import net.irisshaders.iris.gl.texture.TextureType;
import net.irisshaders.iris.helpers.Tri;
import net.irisshaders.iris.pipeline.transform.Patch;
import net.irisshaders.iris.pipeline.transform.PatchShaderType;
import net.irisshaders.iris.shaderpack.materialmap.WorldRenderingSettings;
import net.irisshaders.iris.shaderpack.texture.TextureStage;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.embeddedt.embeddium.impl.render.chunk.vertex.format.ChunkVertexType;
import org.taumc.glsl.ShaderParser;
import org.taumc.glsl.Transformer;
import org.taumc.glsl.grammar.GLSLParser;
import org.taumc.glsl.grammar.GLSLPreParser;

public class ShaderTransformer {
    static String tab = "";
    private static final int CACHE_SIZE = 100;
    private static final Object2ObjectLinkedOpenHashMap<TransformKey, Map<PatchShaderType, String>> shaderTransformationCache = new Object2ObjectLinkedOpenHashMap();

    public static Map<PatchShaderType, String> transform(String name, String vertex, String geometry, String tessControl, String tessEval, String fragment, AlphaTest alpha, ChunkVertexType vertexType, Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> textureMap) {
        EmbeddiumParameters parameters = new EmbeddiumParameters(Patch.EMBEDDIUM, textureMap, alpha, vertexType);
        if (vertex == null && geometry == null && tessControl == null && tessEval == null && fragment == null) {
            return null;
        }
        EnumMap<PatchShaderType, String> inputs = new EnumMap<PatchShaderType, String>(PatchShaderType.class);
        inputs.put(PatchShaderType.VERTEX, vertex);
        inputs.put(PatchShaderType.GEOMETRY, geometry);
        inputs.put(PatchShaderType.TESS_CONTROL, tessControl);
        inputs.put(PatchShaderType.TESS_EVAL, tessEval);
        inputs.put(PatchShaderType.FRAGMENT, fragment);
        TransformKey key = new TransformKey(inputs, parameters);
        Map<PatchShaderType, String> result = (Map<PatchShaderType, String>)shaderTransformationCache.getAndMoveToFirst((Object)key);
        if (result == null) {
            result = ShaderTransformer.transformInternal(name, inputs, parameters);
            parameters.type = null;
            if (shaderTransformationCache.size() >= 100) {
                shaderTransformationCache.removeLast();
            }
            shaderTransformationCache.putAndMoveToLast((Object)key, result);
        }
        return result;
    }

    private static Map<PatchShaderType, String> transformInternal(String name, EnumMap<PatchShaderType, String> inputs, EmbeddiumParameters parameters) {
        EnumMap<PatchShaderType, String> result = new EnumMap<PatchShaderType, String>(PatchShaderType.class);
        EnumMap<PatchShaderType, GLSLParser.Translation_unitContext> types = new EnumMap<PatchShaderType, GLSLParser.Translation_unitContext>(PatchShaderType.class);
        EnumMap<PatchShaderType, String> prepatched = new EnumMap<PatchShaderType, String>(PatchShaderType.class);
        PatchShaderType[] patchShaderTypeArray = PatchShaderType.values();
        int n = patchShaderTypeArray.length;
        for (int i = 0; i < n; ++i) {
            PatchShaderType type;
            parameters.type = type = patchShaderTypeArray[i];
            if (inputs.get((Object)type) == null) continue;
            ShaderParser.ParsedShader parsedShader = ShaderParser.parseShader((String)inputs.get((Object)type));
            GLSLPreParser.Translation_unitContext pre = parsedShader.pre();
            GLSLParser.Translation_unitContext translationUnit = parsedShader.full();
            List preparsed = pre.compiler_directive();
            String profile = null;
            String versionString = null;
            GLSLPreParser.Compiler_directiveContext version = null;
            for (GLSLPreParser.Compiler_directiveContext entry : preparsed) {
                if (entry.version_directive() == null) continue;
                version = entry;
                if (entry.version_directive().number() != null) {
                    versionString = entry.version_directive().number().getText();
                }
                if (entry.version_directive().profile() == null) continue;
                profile = entry.version_directive().profile().getText();
            }
            pre.children.remove(version);
            if (versionString == null) continue;
            Object profileString = "#version " + versionString + " " + profile;
            if (profile == null && Integer.parseInt(versionString) >= 150 || profile != null && profile.equals("core")) {
                if (Integer.parseInt(versionString) < 330) {
                    profileString = "#version 330 core";
                }
                ShaderTransformer.patchCore(translationUnit, parameters);
            } else {
                profileString = Integer.parseInt(versionString) < 330 ? "#version 330 core" : "#version " + versionString + " core";
                ShaderTransformer.patch(translationUnit, parameters);
            }
            CompTransformer.transformEach(translationUnit, parameters);
            TextureTransformer.transform(translationUnit, parameters.getTextureStage(), parameters.getTextureMap());
            types.put(type, translationUnit);
            prepatched.put(type, ShaderTransformer.getFormattedShader((ParseTree)pre, (String)profileString));
        }
        CompTransformer.transformGrouped(types, parameters);
        for (Map.Entry entry : types.entrySet()) {
            result.put((PatchShaderType)((Object)entry.getKey()), ShaderTransformer.getFormattedShader((ParseTree)entry.getValue(), (String)prepatched.get(entry.getKey())));
        }
        return result;
    }

    private static void patch(GLSLParser.Translation_unitContext root, EmbeddiumParameters parameters) {
        Transformer transformer = new Transformer(root);
        ShaderTransformer.commonPatch(transformer, parameters);
        ShaderTransformer.replaceMidTexCoord(transformer, 3.0517578E-5f);
        ShaderTransformer.replaceMCEntity(transformer);
        transformer.replaceExpression("gl_TextureMatrix[0]", "mat4(1.0f)");
        transformer.replaceExpression("gl_TextureMatrix[1]", "iris_LightmapTextureMatrix");
        transformer.injectFunction("uniform mat4 iris_LightmapTextureMatrix;");
        transformer.rename("gl_ProjectionMatrix", "iris_ProjectionMatrix");
        if (parameters.type.glShaderType == ShaderType.VERTEX) {
            transformer.rename("gl_MultiTexCoord2", "gl_MultiTexCoord1");
            transformer.replaceExpression("gl_MultiTexCoord0", "vec4(_vert_tex_diffuse_coord, 0.0f, 1.0f)");
            transformer.replaceExpression("gl_MultiTexCoord1", "vec4(_vert_tex_light_coord, 0.0f, 1.0f)");
            ShaderTransformer.patchMultiTexCoord3(transformer, parameters);
            ShaderTransformer.replaceGlMultiTexCoordBounded(transformer, 4, 7);
        }
        transformer.rename("gl_Color", "_vert_color");
        if (parameters.type.glShaderType == ShaderType.VERTEX) {
            transformer.rename("gl_Normal", "iris_Normal");
            transformer.injectVariable("in vec3 iris_Normal;");
        }
        transformer.replaceExpression("gl_NormalMatrix", "iris_NormalMatrix");
        transformer.injectVariable("uniform mat3 iris_NormalMatrix;");
        transformer.injectVariable("uniform mat4 iris_ModelViewMatrixInverse;");
        transformer.injectVariable("uniform mat4 iris_ProjectionMatrixInverse;");
        transformer.rename("gl_ModelViewMatrix", "iris_ModelViewMatrix");
        transformer.rename("gl_ModelViewMatrixInverse", "iris_ModelViewMatrixInverse");
        transformer.rename("gl_ProjectionMatrixInverse", "iris_ProjectionMatrixInverse");
        if (parameters.type.glShaderType == ShaderType.VERTEX) {
            if (transformer.containsCall("ftransform")) {
                transformer.injectFunction("vec4 ftransform() { return gl_ModelViewProjectionMatrix * gl_Vertex; }");
            }
            transformer.injectFunction("uniform mat4 iris_ProjectionMatrix;");
            transformer.injectFunction("uniform mat4 iris_ModelViewMatrix;");
            transformer.injectFunction("uniform vec3 u_RegionOffset;");
            transformer.injectFunction("vec4 getVertexPosition() { return vec4(_vert_position + u_RegionOffset + _get_draw_translation(_draw_id), 1.0f); }");
            transformer.replaceExpression("gl_Vertex", "getVertexPosition()");
            ShaderTransformer.injectVertInit(transformer, parameters);
        } else {
            transformer.injectVariable("uniform mat4 iris_ModelViewMatrix;");
            transformer.injectFunction("uniform mat4 iris_ProjectionMatrix;");
        }
        transformer.replaceExpression("gl_ModelViewProjectionMatrix", "(iris_ProjectionMatrix * iris_ModelViewMatrix)");
        ShaderTransformer.applyIntelHd4000Workaround(transformer);
    }

    public static void applyIntelHd4000Workaround(Transformer transformer) {
        transformer.renameFunctionCall("ftransform", "iris_ftransform");
    }

    private static void replaceGlMultiTexCoordBounded(Transformer transformer, int min, int max) {
        for (int i = min; i <= max; ++i) {
            transformer.replaceExpression("gl_MultiTexCoord" + i, "vec4(0.0, 0.0, 0.0, 1.0)");
        }
    }

    private static void patchMultiTexCoord3(Transformer transformer, EmbeddiumParameters parameters) {
        if (parameters.type.glShaderType == ShaderType.VERTEX && transformer.hasVariable("gl_MultiTexCoord3") && !transformer.hasVariable("mc_midTexCoord")) {
            transformer.rename("gl_MultiTexCoord3", "mc_midTexCoord");
            transformer.injectVariable("attribute vec4 mc_midTexCoord;");
        }
    }

    private static void patchCore(GLSLParser.Translation_unitContext root, EmbeddiumParameters parameters) {
        Transformer transformer = new Transformer(root);
        transformer.rename("alphaTestRef", "iris_currentAlphaTest");
        transformer.rename("modelViewMatrix", "iris_ModelViewMatrix");
        transformer.rename("modelViewMatrixInverse", "iris_ModelViewMatrixInverse");
        transformer.rename("projectionMatrix", "iris_ProjectionMatrix");
        transformer.rename("projectionMatrixInverse", "iris_ProjectionMatrixInverse");
        transformer.rename("normalMatrix", "iris_NormalMatrix");
        transformer.rename("chunkOffset", "u_RegionOffset");
        transformer.injectVariable("uniform mat4 iris_LightmapTextureMatrix;");
        if (parameters.type == PatchShaderType.VERTEX) {
            transformer.replaceExpression("vaPosition", "_vert_position + _get_draw_translation(_draw_id)");
            transformer.replaceExpression("vaColor", "_vert_color");
            transformer.rename("vaNormal", "iris_Normal");
            transformer.replaceExpression("vaUV0", "_vert_tex_diffuse_coord");
            transformer.replaceExpression("vaUV1", "ivec2(0, 10)");
            transformer.rename("vaUV2", "a_LightCoord");
            transformer.replaceExpression("textureMatrix", "mat4(1.0f)");
            ShaderTransformer.replaceMidTexCoord(transformer, 3.0517578E-5f);
            ShaderTransformer.replaceMCEntity(transformer);
            ShaderTransformer.injectVertInit(transformer, parameters);
        }
    }

    public static void replaceMidTexCoord(Transformer transformer, float textureScale) {
        int type = transformer.findType("mc_midTexCoord");
        if (type != 0) {
            transformer.removeVariable("mc_midTexCoord");
        }
        transformer.replaceExpression("mc_midTexCoord", "iris_MidTex");
        switch (type) {
            case 0: {
                return;
            }
            case 3: {
                return;
            }
            case 36: {
                transformer.injectFunction("float iris_MidTex = (mc_midTexCoord.x * " + textureScale + ");");
                break;
            }
            case 196: {
                transformer.injectFunction("vec2 iris_MidTex = (mc_midTexCoord.xy * " + textureScale + ").xy;");
                break;
            }
            case 197: {
                transformer.injectFunction("vec3 iris_MidTex = vec3(mc_midTexCoord.xy * " + textureScale + ", 0.0);");
                break;
            }
            case 198: {
                transformer.injectFunction("vec4 iris_MidTex = vec4(mc_midTexCoord.xy * " + textureScale + ", 0.0, 1.0);");
                break;
            }
            default: {
                System.out.println("The midTexCoord is of an unexpected type: " + type);
                Iris.logger.error("The midTexCoord is of an unexpected type: " + type);
            }
        }
        transformer.injectVariable("in vec2 mc_midTexCoord;");
    }

    public static void replaceMCEntity(Transformer transformer) {
        int type = transformer.findType("mc_Entity");
        if (type != 0) {
            transformer.removeVariable("mc_Entity");
        }
        transformer.replaceExpression("mc_Entity", "iris_Entity");
        switch (type) {
            case 0: {
                return;
            }
            case 3: {
                return;
            }
            case 36: {
                transformer.injectFunction("float iris_Entity = int(mc_Entity >> 1u) - 1;");
                break;
            }
            case 196: {
                transformer.injectFunction("vec2 iris_Entity = vec2(int(mc_Entity >> 1u) - 1, mc_Entity & 1u);");
                break;
            }
            case 197: {
                transformer.injectFunction("vec3 iris_Entity = vec3(int(mc_Entity >> 1u) - 1, mc_Entity & 1u, 0.0);");
                break;
            }
            case 198: {
                transformer.injectFunction("vec4 iris_Entity = vec4(int(mc_Entity >> 1u) - 1, mc_Entity & 1u, 0.0, 1.0);");
                break;
            }
            case 166: {
                transformer.injectFunction("uint iris_Entity = int(mc_Entity >> 1u) - 1;");
                break;
            }
            case 90: {
                transformer.injectFunction("ivec2 iris_Entity = ivec2(int(mc_Entity >> 1u) - 1, mc_Entity & 1u);");
                break;
            }
            case 91: {
                transformer.injectFunction("ivec3 iris_Entity = ivec3(int(mc_Entity >> 1u) - 1, mc_Entity & 1u, 0);");
                break;
            }
            case 92: {
                transformer.injectFunction("ivec4 iris_Entity = ivec4(int(mc_Entity >> 1u) - 1, mc_Entity & 1u, 0, 1);");
                break;
            }
        }
        transformer.injectVariable("in uint mc_Entity;");
    }

    private static void injectVertInit(Transformer transformer, EmbeddiumParameters parameters) {
        String separateAo = WorldRenderingSettings.INSTANCE.shouldUseSeparateAo() ? "a_Color" : "vec4(a_Color.rgb * a_Color.a, 1.0f)";
        transformer.injectVariable("vec3 _vert_position;");
        transformer.injectVariable("vec2 _vert_tex_diffuse_coord;");
        transformer.injectVariable("ivec2 _vert_tex_light_coord;");
        transformer.injectVariable("vec4 _vert_color;");
        transformer.injectVariable("uint _draw_id;");
        transformer.injectFunction("const uint MATERIAL_USE_MIP_OFFSET = 0u;");
        transformer.injectFunction("vec3 _get_draw_translation(uint pos) {\n    return _get_relative_chunk_coord(pos) * vec3(16.0f);\n}");
        transformer.injectFunction("uvec3 _get_relative_chunk_coord(uint pos) {\n    // Packing scheme is defined by LocalSectionIndex\n    return uvec3(pos) >> uvec3(5u, 0u, 2u) & uvec3(7u, 3u, 7u);\n}");
        transformer.injectFunction("void _vert_init() {_vert_position = (vec3(a_PosId.xyz) * 4.8828125E-4f + -8.0f);_vert_tex_diffuse_coord = (a_TexCoord * 3.0517578E-5);_vert_tex_light_coord = a_LightCoord;_vert_color = " + separateAo + ";_draw_id = (a_PosId.w >> 8u) & 0xFFu; }");
        transformer.injectFunction("float _material_mip_bias(uint material) {\n    return ((material >> MATERIAL_USE_MIP_OFFSET) & 1u) != 0u ? 0.0f : -4.0f;\n}");
        ShaderTransformer.addIfNotExists(transformer, "a_PosId", "in uvec4 a_PosId;");
        ShaderTransformer.addIfNotExists(transformer, "a_TexCoord", "in vec2 a_TexCoord;");
        ShaderTransformer.addIfNotExists(transformer, "a_Color", "in vec4 a_Color;");
        ShaderTransformer.addIfNotExists(transformer, "a_LightCoord", "in ivec2 a_LightCoord;");
        transformer.prependMain("_vert_init();");
    }

    private static void addIfNotExists(Transformer transformer, String name, String code) {
        if (!transformer.hasVariable(name)) {
            transformer.injectVariable(code);
        }
    }

    private static void commonPatch(Transformer transformer, EmbeddiumParameters parameters) {
        transformer.rename("gl_FogFragCoord", "iris_FogFragCoord");
        if (parameters.type.glShaderType == ShaderType.VERTEX) {
            transformer.injectVariable("out float iris_FogFragCoord;");
            transformer.prependMain("iris_FogFragCoord = 0.0f;");
        } else if (parameters.type.glShaderType == ShaderType.FRAGMENT) {
            transformer.injectVariable("in float iris_FogFragCoord;");
        }
        if (parameters.type.glShaderType == ShaderType.VERTEX) {
            transformer.rename("gl_FrontColor", "iris_FrontColor");
            transformer.injectVariable("vec4 iris_FrontColor;");
            transformer.replaceExpression("gl_FrontColor", "iris_FrontColor");
        }
        if (parameters.type.glShaderType == ShaderType.FRAGMENT) {
            if (transformer.containsCall("gl_FragColor")) {
                transformer.replaceExpression("gl_FragColor", "gl_FragData[0]");
            }
            if (transformer.containsCall("gl_TexCoord")) {
                transformer.rename("gl_TexCoord", "irs_texCoords");
                transformer.injectVariable("in vec4 irs_texCoords[3];");
            }
            if (transformer.containsCall("gl_Color")) {
                transformer.rename("gl_Color", "irs_Color");
                transformer.injectVariable("in vec4 irs_Color;");
            }
            HashSet found = new HashSet();
            transformer.renameArray("gl_FragData", "iris_FragData", found);
            for (Integer i : found) {
                transformer.injectFunction("layout (location = " + i + ") out vec4 iris_FragData" + i + ";");
            }
            if (parameters.getAlphaTest() != AlphaTest.ALWAYS && found.contains(0)) {
                transformer.injectVariable("uniform float iris_currentAlphaTest;");
                transformer.appendMain(parameters.getAlphaTest().toExpression("iris_FragData0.a", "iris_currentAlphaTest", ""));
            }
        }
        if (parameters.type.glShaderType == ShaderType.VERTEX || parameters.type.glShaderType == ShaderType.FRAGMENT) {
            ShaderTransformer.upgradeStorageQualifiers(transformer, parameters);
        }
        if (transformer.containsCall("texture") && transformer.hasVariable("texture")) {
            transformer.rename("texture", "gtexture");
        }
        if (transformer.containsCall("gcolor") && transformer.hasVariable("gcolor")) {
            transformer.rename("gcolor", "gtexture");
        }
        transformer.rename("gl_Fog", "iris_Fog");
        transformer.injectVariable("uniform float iris_FogDensity;");
        transformer.injectVariable("uniform float iris_FogStart;");
        transformer.injectVariable("uniform float iris_FogEnd;");
        transformer.injectVariable("uniform vec4 iris_FogColor;");
        transformer.injectFunction("struct iris_FogParameters {vec4 color;float density;float start;float end;float scale;};");
        transformer.injectFunction("iris_FogParameters iris_Fog = iris_FogParameters(iris_FogColor, iris_FogDensity, iris_FogStart, iris_FogEnd, 1.0f / (iris_FogEnd - iris_FogStart));");
        transformer.renameFunctionCall("texture2D", "texture");
        transformer.renameFunctionCall("texture3D", "texture");
        transformer.renameFunctionCall("texture2DLod", "textureLod");
        transformer.renameFunctionCall("texture3DLod", "textureLod");
        transformer.renameFunctionCall("texture2DProj", "textureProj");
        transformer.renameFunctionCall("texture3DProj", "textureProj");
        transformer.renameFunctionCall("texture2DGrad", "textureGrad");
        transformer.renameFunctionCall("texture2DGradARB", "textureGrad");
        transformer.renameFunctionCall("texture3DGrad", "textureGrad");
        transformer.renameFunctionCall("texelFetch2D", "texelFetch");
        transformer.renameFunctionCall("texelFetch3D", "texelFetch");
        transformer.renameFunctionCall("textureSize2D", "textureSize");
        transformer.renameAndWrapShadow("shadow2D", "texture");
        transformer.renameAndWrapShadow("shadow2DLod", "textureLod");
    }

    public static void upgradeStorageQualifiers(Transformer transformer, EmbeddiumParameters parameters) {
        List tokens = transformer.collectStorage();
        for (TerminalNode node : tokens) {
            Token token = node.getSymbol();
            if (!(token instanceof CommonToken)) {
                return;
            }
            CommonToken token2 = (CommonToken)token;
            if (token2.getType() == 2) {
                token2.setType(62);
                token2.setText(GLSLParser.VOCABULARY.getLiteralName(62).replace("'", ""));
                continue;
            }
            if (token2.getType() != 195) continue;
            if (parameters.type.glShaderType == ShaderType.VERTEX) {
                token2.setType(109);
                token2.setText(GLSLParser.VOCABULARY.getLiteralName(109).replace("'", ""));
                continue;
            }
            token2.setType(62);
            token2.setText(GLSLParser.VOCABULARY.getLiteralName(62).replace("'", ""));
        }
    }

    public static String getFormattedShader(ParseTree tree, String string) {
        StringBuilder sb = new StringBuilder(string + "\n");
        ShaderTransformer.getFormattedShader(tree, sb);
        return sb.toString();
    }

    private static void getFormattedShader(ParseTree tree, StringBuilder stringBuilder) {
        if (tree instanceof TerminalNode) {
            String text = tree.getText();
            if (text.equals("<EOF>")) {
                return;
            }
            if (text.equals("#")) {
                stringBuilder.append("\n#");
                return;
            }
            stringBuilder.append(text);
            if (text.equals("{")) {
                stringBuilder.append(" \n\t");
                tab = "\t";
            }
            if (text.equals("}")) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 2);
                tab = "";
            }
            stringBuilder.append((String)(text.equals(";") ? " \n" + tab : " "));
        } else {
            for (int i = 0; i < tree.getChildCount(); ++i) {
                ShaderTransformer.getFormattedShader(tree.getChild(i), stringBuilder);
            }
        }
    }

    private record TransformKey(EnumMap<PatchShaderType, String> inputs, EmbeddiumParameters params) {
    }
}

