/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.compat.embeddium.impl.monocle;

import java.util.Map;
import net.irisshaders.iris.compat.embeddium.impl.monocle.EmbeddiumParameters;
import net.irisshaders.iris.gl.shader.ShaderType;
import net.irisshaders.iris.pipeline.transform.PatchShaderType;
import org.antlr.v4.runtime.tree.ParseTree;
import org.taumc.glsl.Transformer;
import org.taumc.glsl.grammar.GLSLParser;

public class CompTransformer {
    private static final ShaderType[] pipeline = new ShaderType[]{ShaderType.VERTEX, ShaderType.TESSELATION_CONTROL, ShaderType.TESSELATION_EVAL, ShaderType.GEOMETRY, ShaderType.FRAGMENT};

    public static void transformEach(GLSLParser.Translation_unitContext root, EmbeddiumParameters parameters) {
        Transformer transformer = new Transformer(root);
        if (parameters.type == PatchShaderType.VERTEX && transformer.containsCall("fract(worldpos.y + 0.001)")) {
            transformer.replaceExpression("fract(worldpos.y + 0.001)", "fract(worldpos.y + 0.01)");
        }
        transformer.removeUnusedFunctions();
        transformer.removeConstAssignment();
        transformer.rewriteStructArrays();
    }

    public static void transformGrouped(Map<PatchShaderType, GLSLParser.Translation_unitContext> trees, EmbeddiumParameters parameters) {
        ShaderType prevType = null;
        for (ShaderType type : pipeline) {
            PatchShaderType[] patchTypes = PatchShaderType.fromGlShaderType(type);
            boolean hasAny = false;
            for (PatchShaderType currentType : patchTypes) {
                if (trees.get((Object)currentType) == null) continue;
                hasAny = true;
            }
            if (!hasAny) continue;
            if (prevType == null) {
                prevType = type;
                continue;
            }
            PatchShaderType prevPatchTypes = PatchShaderType.fromGlShaderType(prevType)[0];
            GLSLParser.Translation_unitContext prevTree = trees.get((Object)prevPatchTypes);
            Transformer prevtransformer = new Transformer(prevTree);
            Map outDec = prevtransformer.findQualifiers(109);
            for (PatchShaderType currentType : patchTypes) {
                GLSLParser.Translation_unitContext currentTree = trees.get((Object)currentType);
                Transformer currentTransformer = new Transformer(currentTree);
                if (currentTree == null) continue;
                Map inDec = currentTransformer.findQualifiers(62);
                for (String in : inDec.keySet()) {
                    if (in.startsWith("gl_")) continue;
                    if (!outDec.containsKey(in)) {
                        if (!currentTransformer.containsCall(in)) continue;
                        prevtransformer.makeOutDeclaration((GLSLParser.Single_declarationContext)inDec.get(in), in);
                        if (prevtransformer.hasAssigment(in)) continue;
                        prevtransformer.initialize((GLSLParser.Single_declarationContext)inDec.get(in), in);
                        continue;
                    }
                    ParseTree outType = (ParseTree)((GLSLParser.Single_declarationContext)outDec.get((Object)in)).fully_specified_type().type_specifier().type_specifier_nonarray().children.get(0);
                    ParseTree inType = (ParseTree)((GLSLParser.Single_declarationContext)inDec.get((Object)in)).fully_specified_type().type_specifier().type_specifier_nonarray().children.get(0);
                    if (((GLSLParser.Single_declarationContext)outDec.get(in)).fully_specified_type().type_specifier().array_specifier() != null || !inType.getText().equals(outType.getText()) || prevtransformer.hasAssigment(in)) continue;
                    prevtransformer.initialize((GLSLParser.Single_declarationContext)inDec.get(in), in);
                }
            }
            prevType = type;
        }
    }
}

