/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.world.biome;

import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;

public class BiomeColorMaps {
    private static final int WIDTH = 256;
    private static final int HEIGHT = 256;
    private static final int INVALID_INDEX = -1;
    private static final int DEFAULT_COLOR = -65281;

    public static int getGrassColor(int index) {
        if (index == -1 || index >= GrassColor.pixels.length) {
            return -65281;
        }
        return GrassColor.pixels[index];
    }

    public static int getFoliageColor(int index) {
        if (index == -1 || index >= FoliageColor.pixels.length) {
            return -65281;
        }
        return FoliageColor.pixels[index];
    }

    public static int getIndex(double temperature, double humidity) {
        int x = (int)((1.0 - temperature) * 255.0);
        int y = (int)((1.0 - (humidity *= temperature)) * 255.0);
        if (x < 0 || x >= 256) {
            return -1;
        }
        if (y < 0 || y >= 256) {
            return -1;
        }
        return y << 8 | x;
    }
}

