/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.model.quad.blender;

import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import org.embeddedt.embeddium.api.render.chunk.EmbeddiumBlockAndTintGetter;
import org.embeddedt.embeddium.api.util.ColorARGB;
import org.embeddedt.embeddium.api.util.ColorMixer;
import org.embeddedt.embeddium.impl.model.color.ColorProvider;
import org.embeddedt.embeddium.impl.model.quad.ModelQuadView;

public abstract class BlendedColorProvider<T>
implements ColorProvider<T> {
    private static boolean shouldUseVertexBlending;
    private final BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();

    public static void checkBlendingEnabled() {
        shouldUseVertexBlending = (Integer)Minecraft.getInstance().options.biomeBlendRadius().get() > 0;
    }

    @Override
    public void getColors(EmbeddiumBlockAndTintGetter view, BlockPos pos, T state, ModelQuadView quad, int[] output) {
        if (shouldUseVertexBlending) {
            for (int vertexIndex = 0; vertexIndex < 4; ++vertexIndex) {
                output[vertexIndex] = this.getVertexColor(view, pos, quad, vertexIndex);
            }
        } else {
            Arrays.fill(output, ColorARGB.toABGR(this.getColor(view, pos)));
        }
    }

    private int getVertexColor(EmbeddiumBlockAndTintGetter world, BlockPos blockPos, ModelQuadView quad, int vertexIndex) {
        float posX = quad.getX(vertexIndex) - 0.5f;
        float posY = quad.getY(vertexIndex) - 0.5f;
        float posZ = quad.getZ(vertexIndex) - 0.5f;
        int intX = Mth.floor((float)posX);
        int intY = Mth.floor((float)posY);
        int intZ = Mth.floor((float)posZ);
        int worldIntX = blockPos.getX() + intX;
        int worldIntY = blockPos.getY() + intY;
        int worldIntZ = blockPos.getZ() + intZ;
        BlockPos.MutableBlockPos neighborPos = this.cursor;
        int c00 = this.getColor(world, (BlockPos)neighborPos.set(worldIntX + 0, worldIntY, worldIntZ + 0));
        int c01 = this.getColor(world, (BlockPos)neighborPos.set(worldIntX + 0, worldIntY, worldIntZ + 1));
        int c10 = this.getColor(world, (BlockPos)neighborPos.set(worldIntX + 1, worldIntY, worldIntZ + 0));
        int c11 = this.getColor(world, (BlockPos)neighborPos.set(worldIntX + 1, worldIntY, worldIntZ + 1));
        int z0 = c00 != c01 ? ColorMixer.mix(c00, c01, posZ - (float)intZ) : c00;
        int z1 = c10 != c11 ? ColorMixer.mix(c10, c11, posZ - (float)intZ) : c10;
        int x0 = z0 != z1 ? ColorMixer.mix(z0, z1, posX - (float)intX) : z0;
        return ColorARGB.toABGR(x0);
    }

    protected abstract int getColor(EmbeddiumBlockAndTintGetter var1, BlockPos var2);
}

