/*
 * Decompiled with CFR 0.152.
 */
package com.github.cpburnz.minecraft_prometheus_exporter;

import com.mojang.logging.LogUtils;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

public class ServerConfig {
    private static final Logger LOG = LogUtils.getLogger();
    public boolean collector_jvm;
    public boolean collector_mc;
    public TickErrorPolicy collector_mc_dimension_tick_errors;
    public boolean collector_mc_entities;
    private final ModConfigSpec forge_spec;
    private final InternalSpec internal_spec;
    private boolean is_loaded;
    public String web_listen_address;
    public int web_listen_port;

    public ServerConfig() {
        Pair result = new ModConfigSpec.Builder().configure(InternalSpec::new);
        this.internal_spec = (InternalSpec)result.getLeft();
        this.forge_spec = (ModConfigSpec)result.getRight();
    }

    public boolean isLoaded() {
        return this.is_loaded;
    }

    public void loadValues() {
        this.collector_jvm = (Boolean)this.internal_spec.collector_jvm.get();
        this.collector_mc = (Boolean)this.internal_spec.collector_mc.get();
        this.collector_mc_dimension_tick_errors = (TickErrorPolicy)((Object)this.internal_spec.collector_mc_dimension_tick_errors.get());
        this.collector_mc_entities = (Boolean)this.internal_spec.collector_mc_entities.get();
        this.web_listen_address = (String)this.internal_spec.web_listen_address.get();
        this.web_listen_port = (Integer)this.internal_spec.web_listen_port.get();
        this.is_loaded = true;
        LOG.debug("collector.jvm: {}", (Object)this.collector_jvm);
        LOG.debug("collector.mc: {}", (Object)this.collector_mc);
        LOG.debug("collector.mc_dimension_tick_errors: {}", (Object)this.collector_mc_dimension_tick_errors);
        LOG.debug("collector.mc_entities: {}", (Object)this.collector_mc_entities);
        LOG.debug("web.listen_address: {}", (Object)this.web_listen_address);
        LOG.debug("web.listen_port: {}", (Object)this.web_listen_port);
    }

    public void register() {
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)this.forge_spec);
    }

    private static class InternalSpec {
        private static final String DEFAULT_ADDRESS = "0.0.0.0";
        private static final int DEFAULT_PORT = 19565;
        private static final int TCP_PORT_MAX = 65535;
        private static final int TCP_PORT_MIN = 0;
        public final ModConfigSpec.BooleanValue collector_jvm;
        public final ModConfigSpec.BooleanValue collector_mc;
        public final ModConfigSpec.EnumValue<TickErrorPolicy> collector_mc_dimension_tick_errors;
        public final ModConfigSpec.BooleanValue collector_mc_entities;
        public final ModConfigSpec.ConfigValue<String> web_listen_address;
        public final ModConfigSpec.IntValue web_listen_port;

        public InternalSpec(ModConfigSpec.Builder builder) {
            builder.comment("Collector settings.").push("collector");
            this.collector_jvm = builder.comment("Enable collecting metrics about the JVM process.").define("jvm", true);
            this.collector_mc = builder.comment("Enable collecting metrics about the Minecraft server.").define("mc", true);
            this.collector_mc_dimension_tick_errors = builder.comment(new String[]{"Configure how to handle dimension (world) tick errors. Some mods handle the tick events for their custom dimensions, and may not reliably start and stop ticks as expected.", "  IGNORE: Ignore tick errors. If a mod really botches tick events, it could emit up to 20 log statements per second for each dimension. This would cause large ballooning of the \"logs/debug.txt\" file. Use this setting, or figure out how to filter out DEBUG messages for \"com.github.cpburnz.minecraft_prometheus_exporter.MinecraftCollector/\" in \"log4j2.xml\".", "  LOG: Log tick errors. This is the new default.", "  STRICT: Raise an exception on tick error. This will crash the server if an error occurs."}).defineEnum("mc_dimension_tick_errors", (Enum)TickErrorPolicy.LOG);
            this.collector_mc_entities = builder.comment("Enable collecting metrics about the entities in each dimension (world).").define("mc_entities", true);
            builder.pop();
            builder.comment("Web server settings.").push("web");
            this.web_listen_address = builder.comment("The IP address to listen on. To only allow connections from the local machine, use \"127.0.0.1\". To allow connections from remote machines, use \"0.0.0.0\".").define("listen_address", (Object)DEFAULT_ADDRESS);
            this.web_listen_port = builder.comment("The TCP port to listen on. Ports 1-1023 will not work unless Minecraft is run as root which is not recommended.").defineInRange("listen_port", 19565, 0, 65535);
            builder.pop();
        }
    }

    public static enum TickErrorPolicy {
        IGNORE,
        LOG,
        STRICT;

    }
}

