/*
 * Decompiled with CFR 0.152.
 */
package com.github.cpburnz.minecraft_prometheus_exporter;

import com.github.cpburnz.minecraft_prometheus_exporter.MinecraftCollector;
import com.github.cpburnz.minecraft_prometheus_exporter.ServerConfig;
import com.github.cpburnz.minecraft_prometheus_exporter.vendors.io.prometheus.client.CollectorRegistry;
import com.github.cpburnz.minecraft_prometheus_exporter.vendors.io.prometheus.client.exporter.HTTPServer;
import com.github.cpburnz.minecraft_prometheus_exporter.vendors.io.prometheus.client.hotspot.DefaultExports;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.slf4j.Logger;

@Mod(value="prometheus_exporter")
public class PrometheusExporterMod {
    private static final Logger LOG = LogUtils.getLogger();
    public static final String MOD_ID = "prometheus_exporter";
    private HTTPServer http_server;
    private MinecraftCollector mc_collector;
    private MinecraftServer mc_server;
    private final ServerConfig config;

    public PrometheusExporterMod() {
        NeoForge.EVENT_BUS.register((Object)this);
        this.config = new ServerConfig();
        this.config.register();
    }

    private void closeCollectors() {
        CollectorRegistry.defaultRegistry.clear();
    }

    private void closeHttpServer() {
        if (this.http_server != null) {
            this.http_server.close();
            this.http_server = null;
        } else {
            LOG.warn("Cannot close http_server=null.");
        }
    }

    private void initCollectors() {
        if (this.config.collector_jvm) {
            DefaultExports.initialize();
        }
        if (this.config.collector_mc) {
            this.mc_collector = new MinecraftCollector(this.config, this.mc_server);
            this.mc_collector.register();
        }
    }

    private void initHttpServer() throws IOException {
        String address = this.config.web_listen_address;
        int port = this.config.web_listen_port;
        this.http_server = new HTTPServer(address, port, true);
        LOG.info("Listening on {}:{}", (Object)address, (Object)port);
    }

    @SubscribeEvent
    public void onDimensionTickStart(LevelTickEvent.Pre event) {
        Level level;
        if (this.mc_collector != null && !(level = event.getLevel()).isClientSide()) {
            ResourceKey dim = level.dimension();
            this.mc_collector.startDimensionTick((ResourceKey<Level>)dim);
        }
    }

    @SubscribeEvent
    public void onDimensionTickStop(LevelTickEvent.Post event) {
        Level level;
        if (this.mc_collector != null && !(level = event.getLevel()).isClientSide()) {
            ResourceKey dim = level.dimension();
            this.mc_collector.stopDimensionTick((ResourceKey<Level>)dim);
        }
    }

    @SubscribeEvent
    public void onServerAboutToStart(ServerAboutToStartEvent event) {
        this.config.loadValues();
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) throws IOException {
        this.mc_server = event.getServer();
        this.initHttpServer();
        this.initCollectors();
    }

    @SubscribeEvent
    public void onServerStopped(ServerStoppedEvent event) {
        this.closeCollectors();
        this.closeHttpServer();
    }

    @SubscribeEvent
    public void onServerTickStart(ServerTickEvent.Pre event) {
        if (this.mc_collector != null) {
            this.mc_collector.startServerTick();
        }
    }

    @SubscribeEvent
    public void onServerTickStop(ServerTickEvent.Post event) {
        if (this.mc_collector != null) {
            this.mc_collector.stopServerTick();
        }
    }
}

