/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.facet.taxonomy;

import guideme.internal.shaded.lucene.facet.FacetsCollector;
import guideme.internal.shaded.lucene.facet.FacetsConfig;
import guideme.internal.shaded.lucene.facet.TopOrdAndIntQueue;
import guideme.internal.shaded.lucene.facet.TopOrdAndNumberQueue;
import guideme.internal.shaded.lucene.facet.taxonomy.AssociationAggregationFunction;
import guideme.internal.shaded.lucene.facet.taxonomy.ParallelTaxonomyArrays;
import guideme.internal.shaded.lucene.facet.taxonomy.TaxonomyFacets;
import guideme.internal.shaded.lucene.facet.taxonomy.TaxonomyReader;
import guideme.internal.shaded.lucene.internal.hppc.IntIntHashMap;
import java.io.IOException;
import java.util.Comparator;

abstract class IntTaxonomyFacets
extends TaxonomyFacets {
    protected final AssociationAggregationFunction aggregationFunction;
    int[] values;
    IntIntHashMap sparseValues;

    IntTaxonomyFacets(String indexFieldName, TaxonomyReader taxoReader, FacetsConfig config, AssociationAggregationFunction aggregationFunction, FacetsCollector fc) throws IOException {
        super(indexFieldName, taxoReader, config, fc);
        this.aggregationFunction = aggregationFunction;
        this.valueComparator = Comparator.comparingInt(o -> (Integer)o);
    }

    @Override
    protected void initializeValueCounters() {
        if (this.initialized) {
            return;
        }
        super.initializeValueCounters();
        assert (this.sparseValues == null && this.values == null);
        if (this.sparseCounts != null) {
            this.sparseValues = new IntIntHashMap();
        } else {
            this.values = new int[this.taxoReader.getSize()];
        }
    }

    void setValue(int ordinal, int newValue) {
        if (this.sparseValues != null) {
            this.sparseValues.put(ordinal, newValue);
        } else {
            this.values[ordinal] = newValue;
        }
    }

    int getValue(int ordinal) {
        if (this.sparseValues != null) {
            return this.sparseValues.get(ordinal);
        }
        return this.values[ordinal];
    }

    @Override
    protected Number getAggregationValue(int ordinal) {
        return this.getValue(ordinal);
    }

    @Override
    protected Number aggregate(Number existingVal, Number newVal) {
        return this.aggregationFunction.aggregate((Integer)existingVal, (Integer)newVal);
    }

    @Override
    protected void updateValueFromRollup(int ordinal, int childOrdinal) throws IOException {
        super.updateValueFromRollup(ordinal, childOrdinal);
        int currentValue = this.getValue(ordinal);
        int newValue = this.aggregationFunction.aggregate(currentValue, this.rollup(childOrdinal));
        this.setValue(ordinal, newValue);
    }

    private int rollup(int ord) throws IOException {
        ParallelTaxonomyArrays.IntArray children = this.getChildren();
        ParallelTaxonomyArrays.IntArray siblings = this.getSiblings();
        int aggregatedValue = 0;
        while (ord != -1) {
            this.updateValueFromRollup(ord, children.get(ord));
            aggregatedValue = this.aggregationFunction.aggregate(aggregatedValue, this.getValue(ord));
            ord = siblings.get(ord);
        }
        return aggregatedValue;
    }

    @Override
    protected void setIncomingValue(TopOrdAndNumberQueue.OrdAndValue incomingOrdAndValue, int ord) {
        ((TopOrdAndIntQueue.OrdAndInt)incomingOrdAndValue).value = this.getValue(ord);
    }

    @Override
    protected TaxonomyFacets.AggregatedValue newAggregatedValue() {
        return new IntAggregatedValue(0);
    }

    protected class IntAggregatedValue
    extends TaxonomyFacets.AggregatedValue {
        private int value;

        public IntAggregatedValue(int value) {
            this.value = value;
        }

        @Override
        public void aggregate(int ord) {
            this.value = IntTaxonomyFacets.this.aggregationFunction.aggregate(this.value, IntTaxonomyFacets.this.getValue(ord));
        }

        @Override
        public Number get() {
            return this.value;
        }
    }
}

