/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.datagen.RecipeGen;

import com.mrh0.createaddition.recipe.charging.ChargingRecipe;
import com.mrh0.createaddition.recipe.charging.ChargingRecipeParams;
import com.simibubi.create.api.data.recipe.BaseRecipeProvider;
import com.simibubi.create.api.data.recipe.ProcessingRecipeGen;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.DataMapHooks;

public class ChargingRecipeGen
extends ProcessingRecipeGen<ChargingRecipeParams, ChargingRecipe, ChargingRecipe.Builder<ChargingRecipe>> {
    protected final HolderLookup.Provider provider;

    public ChargingRecipeGen(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, String defaultNamespace) {
        super(output, registries, defaultNamespace);
        try {
            this.provider = registries.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public BaseRecipeProvider.GeneratedRecipe deoxidize(Block block, Block deoxidizedBlock) {
        ResourceLocation id = block.builtInRegistryHolder().key().location();
        return this.create("deoxidize_" + id.getNamespace() + "_" + id.getPath(), b -> ((ChargingRecipe.Builder)((ChargingRecipe.Builder)b.require((ItemLike)block)).output((ItemLike)deoxidizedBlock)).energy(4000).maxChargeRate(200));
    }

    public BaseRecipeProvider.GeneratedRecipe deoxidize(Block block) {
        Optional<Block> deoxidizedBlock = Optional.ofNullable(DataMapHooks.getPreviousOxidizedStage((Block)block));
        if (deoxidizedBlock.isEmpty()) {
            throw new IllegalStateException("Cannot de-oxidize " + String.valueOf(block));
        }
        return this.deoxidize(block, deoxidizedBlock.get());
    }

    protected IRecipeTypeInfo getRecipeType() {
        return ChargingRecipe.TYPE_INFO;
    }

    protected ChargingRecipe.Builder<ChargingRecipe> getBuilder(ResourceLocation id) {
        return new ChargingRecipe.Builder<ChargingRecipe>(ChargingRecipe::new, id);
    }
}

