/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.shadow.airlift.compress.lz4;

import de.bluecolored.shadow.airlift.compress.lz4.UnsafeUtil;
import java.util.Arrays;

public final class Lz4RawCompressor {
    private static final int MAX_INPUT_SIZE = 0x7E000000;
    private static final int HASH_LOG = 12;
    private static final int MIN_TABLE_SIZE = 16;
    public static final int MAX_TABLE_SIZE = 4096;
    private static final int COPY_LENGTH = 8;
    private static final int MATCH_FIND_LIMIT = 12;
    private static final int MIN_LENGTH = 13;
    private static final int ML_BITS = 4;
    private static final int ML_MASK = 15;
    private static final int RUN_BITS = 4;
    private static final int RUN_MASK = 15;
    private static final int MAX_DISTANCE = 65535;
    private static final int SKIP_TRIGGER = 6;

    private Lz4RawCompressor() {
    }

    private static int hash(long value, int mask) {
        return (int)(value * 889523592379L >>> 28 & (long)mask);
    }

    public static int maxCompressedLength(int sourceLength) {
        return sourceLength + sourceLength / 255 + 16;
    }

    public static int compress(Object inputBase, long inputAddress, int inputLength, Object outputBase, long outputAddress, long maxOutputLength, int[] table) {
        int tableSize = Lz4RawCompressor.computeTableSize(inputLength);
        Arrays.fill(table, 0, tableSize, 0);
        int mask = tableSize - 1;
        if (inputLength > 0x7E000000) {
            throw new IllegalArgumentException("Max input length exceeded");
        }
        if (maxOutputLength < (long)Lz4RawCompressor.maxCompressedLength(inputLength)) {
            throw new IllegalArgumentException("Max output length must be larger than " + Lz4RawCompressor.maxCompressedLength(inputLength));
        }
        long input = inputAddress;
        long output = outputAddress;
        long inputLimit = inputAddress + (long)inputLength;
        long matchFindLimit = inputLimit - 12L;
        long matchLimit = inputLimit - 5L;
        if (inputLength < 13) {
            output = Lz4RawCompressor.emitLastLiteral(outputBase, output, inputBase, input, inputLimit - input);
            return (int)(output - outputAddress);
        }
        long anchor = input;
        table[Lz4RawCompressor.hash((long)UnsafeUtil.UNSAFE.getLong((Object)inputBase, (long)input), (int)mask)] = (int)(input - inputAddress);
        int nextHash = Lz4RawCompressor.hash(UnsafeUtil.UNSAFE.getLong(inputBase, ++input), mask);
        boolean done = false;
        block0: do {
            long matchIndex;
            long nextInputIndex = input;
            int findMatchAttempts = 64;
            int step = 1;
            do {
                int hash = nextHash;
                input = nextInputIndex;
                if ((nextInputIndex += (long)(step = findMatchAttempts++ >>> 6)) > matchFindLimit) {
                    return (int)(Lz4RawCompressor.emitLastLiteral(outputBase, output, inputBase, anchor, inputLimit - anchor) - outputAddress);
                }
                nextHash = Lz4RawCompressor.hash(UnsafeUtil.UNSAFE.getLong(inputBase, nextInputIndex), mask);
                table[hash] = (int)(input - inputAddress);
            } while (UnsafeUtil.UNSAFE.getInt(inputBase, matchIndex) != UnsafeUtil.UNSAFE.getInt(inputBase, input) || matchIndex + 65535L < input);
            for (matchIndex = inputAddress + (long)table[hash]; input > anchor && matchIndex > inputAddress && UnsafeUtil.UNSAFE.getByte(inputBase, input - 1L) == UnsafeUtil.UNSAFE.getByte(inputBase, matchIndex - 1L); --input, --matchIndex) {
            }
            int literalLength = (int)(input - anchor);
            long tokenAddress = output;
            output = Lz4RawCompressor.emitLiteral(inputBase, outputBase, anchor, literalLength, tokenAddress);
            while (true) {
                int matchLength = Lz4RawCompressor.count(inputBase, input + 4L, matchLimit, matchIndex + 4L);
                output = Lz4RawCompressor.emitMatch(outputBase, output, tokenAddress, (short)(input - matchIndex), matchLength);
                anchor = input += (long)(matchLength + 4);
                if (input > matchFindLimit) {
                    done = true;
                    continue block0;
                }
                long position = input - 2L;
                table[Lz4RawCompressor.hash((long)UnsafeUtil.UNSAFE.getLong((Object)inputBase, (long)position), (int)mask)] = (int)(position - inputAddress);
                int hash = Lz4RawCompressor.hash(UnsafeUtil.UNSAFE.getLong(inputBase, input), mask);
                matchIndex = inputAddress + (long)table[hash];
                table[hash] = (int)(input - inputAddress);
                if (matchIndex + 65535L < input || UnsafeUtil.UNSAFE.getInt(inputBase, matchIndex) != UnsafeUtil.UNSAFE.getInt(inputBase, input)) {
                    nextHash = Lz4RawCompressor.hash(UnsafeUtil.UNSAFE.getLong(inputBase, ++input), mask);
                    continue block0;
                }
                ++output;
                UnsafeUtil.UNSAFE.putByte(outputBase, tokenAddress, (byte)0);
            }
        } while (!done);
        output = Lz4RawCompressor.emitLastLiteral(outputBase, output, inputBase, anchor, inputLimit - anchor);
        return (int)(output - outputAddress);
    }

    private static long emitLiteral(Object inputBase, Object outputBase, long input, int literalLength, long output) {
        output = Lz4RawCompressor.encodeRunLength(outputBase, output, literalLength);
        long outputLimit = output + (long)literalLength;
        do {
            UnsafeUtil.UNSAFE.putLong(outputBase, output, UnsafeUtil.UNSAFE.getLong(inputBase, input));
            input += 8L;
        } while ((output += 8L) < outputLimit);
        return outputLimit;
    }

    private static long emitMatch(Object outputBase, long output, long tokenAddress, short offset, long matchLength) {
        UnsafeUtil.UNSAFE.putShort(outputBase, output, offset);
        output += 2L;
        if (matchLength >= 15L) {
            long remaining;
            UnsafeUtil.UNSAFE.putByte(outputBase, tokenAddress, (byte)(UnsafeUtil.UNSAFE.getByte(outputBase, tokenAddress) | 0xF));
            for (remaining = matchLength - 15L; remaining >= 510L; remaining -= 510L) {
                UnsafeUtil.UNSAFE.putShort(outputBase, output, (short)-1);
                output += 2L;
            }
            if (remaining >= 255L) {
                UnsafeUtil.UNSAFE.putByte(outputBase, output++, (byte)-1);
                remaining -= 255L;
            }
            UnsafeUtil.UNSAFE.putByte(outputBase, output++, (byte)remaining);
        } else {
            UnsafeUtil.UNSAFE.putByte(outputBase, tokenAddress, (byte)((long)UnsafeUtil.UNSAFE.getByte(outputBase, tokenAddress) | matchLength));
        }
        return output;
    }

    static int count(Object inputBase, long inputAddress, long inputLimit, long matchAddress) {
        long input = inputAddress;
        long match = matchAddress;
        int remaining = (int)(inputLimit - inputAddress);
        int count = 0;
        while (count < remaining - 7) {
            long diff = UnsafeUtil.UNSAFE.getLong(inputBase, match) ^ UnsafeUtil.UNSAFE.getLong(inputBase, input);
            if (diff != 0L) {
                return count + (Long.numberOfTrailingZeros(diff) >> 3);
            }
            count += 8;
            input += 8L;
            match += 8L;
        }
        while (count < remaining && UnsafeUtil.UNSAFE.getByte(inputBase, match) == UnsafeUtil.UNSAFE.getByte(inputBase, input)) {
            ++count;
            ++match;
            ++input;
        }
        return count;
    }

    private static long emitLastLiteral(Object outputBase, long outputAddress, Object inputBase, long inputAddress, long length) {
        long output = Lz4RawCompressor.encodeRunLength(outputBase, outputAddress, length);
        UnsafeUtil.UNSAFE.copyMemory(inputBase, inputAddress, outputBase, output, length);
        return output + length;
    }

    private static long encodeRunLength(Object base, long output, long length) {
        if (length >= 15L) {
            long remaining;
            UnsafeUtil.UNSAFE.putByte(base, output++, (byte)-16);
            for (remaining = length - 15L; remaining >= 255L; remaining -= 255L) {
                UnsafeUtil.UNSAFE.putByte(base, output++, (byte)-1);
            }
            UnsafeUtil.UNSAFE.putByte(base, output++, (byte)remaining);
        } else {
            UnsafeUtil.UNSAFE.putByte(base, output++, (byte)(length << 4));
        }
        return output;
    }

    private static int computeTableSize(int inputSize) {
        int target = Integer.highestOneBit(inputSize - 1) << 1;
        return Math.max(Math.min(target, 4096), 16);
    }
}

