/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.storage.sql;

import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.shadow.apache.commons.dbcp2.ConnectionFactory;
import de.bluecolored.shadow.apache.commons.dbcp2.DriverConnectionFactory;
import de.bluecolored.shadow.apache.commons.dbcp2.DriverManagerConnectionFactory;
import de.bluecolored.shadow.apache.commons.dbcp2.PoolableConnection;
import de.bluecolored.shadow.apache.commons.dbcp2.PoolableConnectionFactory;
import de.bluecolored.shadow.apache.commons.dbcp2.PoolingDataSource;
import de.bluecolored.shadow.apache.commons.pool2.impl.GenericObjectPool;
import de.bluecolored.shadow.apache.commons.pool2.impl.GenericObjectPoolConfig;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;

public class Database
implements Closeable {
    private final DataSource dataSource;
    private boolean isClosed = false;

    public Database(String url, Map<String, String> properties, int maxPoolSize) {
        Properties props = new Properties();
        props.putAll(properties);
        this.dataSource = this.createDataSource(new DriverManagerConnectionFactory(url, props), maxPoolSize);
    }

    public Database(String url, Map<String, String> properties, int maxPoolSize, Driver driver) {
        Properties props = new Properties();
        props.putAll(properties);
        DriverConnectionFactory connectionFactory = new DriverConnectionFactory(driver, url, props);
        this.dataSource = this.createDataSource(connectionFactory, maxPoolSize);
    }

    public void run(ConnectionConsumer action) throws IOException {
        this.run((ConnectionFunction)action);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <R> R run(ConnectionFunction<R> action) throws IOException {
        SQLRecoverableException sqlException = null;
        try {
            int i = 0;
            while (i < 2) {
                try (Connection connection = this.dataSource.getConnection();){
                    R result = action.apply(connection);
                    connection.commit();
                    R r = result;
                    return r;
                }
                ++i;
            }
            throw new IOException(sqlException);
        }
        catch (SQLException ex) {
            if (sqlException == null) throw new IOException(ex);
            ex.addSuppressed(sqlException);
            throw new IOException(ex);
        }
        catch (IOException | RuntimeException ex) {
            if (sqlException == null) throw ex;
            ex.addSuppressed(sqlException);
            throw ex;
        }
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
        if (this.dataSource instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)this.dataSource)).close();
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new IOException("Failed to close datasource!", ex);
            }
        }
    }

    private DataSource createDataSource(ConnectionFactory connectionFactory, int maxPoolSize) {
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory(() -> {
            Logger.global.logDebug("Creating new SQL-Connection...");
            return connectionFactory.createConnection();
        }, null);
        poolableConnectionFactory.setPoolStatements(true);
        poolableConnectionFactory.setMaxOpenPreparedStatements(20);
        poolableConnectionFactory.setDefaultAutoCommit(false);
        poolableConnectionFactory.setAutoCommitOnReturn(false);
        poolableConnectionFactory.setRollbackOnReturn(true);
        poolableConnectionFactory.setFastFailValidation(true);
        GenericObjectPoolConfig objectPoolConfig = new GenericObjectPoolConfig();
        objectPoolConfig.setTestWhileIdle(true);
        objectPoolConfig.setTimeBetweenEvictionRuns(Duration.ofSeconds(10L));
        objectPoolConfig.setNumTestsPerEvictionRun(3);
        objectPoolConfig.setBlockWhenExhausted(true);
        objectPoolConfig.setMinIdle(1);
        objectPoolConfig.setMaxIdle(Runtime.getRuntime().availableProcessors());
        objectPoolConfig.setMaxTotal(maxPoolSize);
        objectPoolConfig.setMaxWaitMillis(Duration.ofSeconds(30L).toMillis());
        GenericObjectPool<PoolableConnection> connectionPool = new GenericObjectPool<PoolableConnection>(poolableConnectionFactory, objectPoolConfig);
        poolableConnectionFactory.setPool(connectionPool);
        return new PoolingDataSource<PoolableConnection>(connectionPool);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public Database(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @FunctionalInterface
    public static interface ConnectionFunction<R> {
        public R apply(Connection var1) throws SQLException, IOException;
    }

    @FunctionalInterface
    public static interface ConnectionConsumer
    extends ConnectionFunction<Void> {
        public void accept(Connection var1) throws SQLException, IOException;

        @Override
        default public Void apply(Connection connection) throws SQLException, IOException {
            this.accept(connection);
            return null;
        }
    }
}

