/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.commands.checks;

import de.bluecolored.bluemap.common.BlueMapConfiguration;
import de.bluecolored.bluemap.common.commands.TextFormat;
import de.bluecolored.bluemap.common.commands.checks.Check;
import de.bluecolored.bluemap.common.commands.checks.CheckResult;
import de.bluecolored.bluemap.common.config.BlueMapConfigManager;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.shadow.adventure.adventure.text.Component;
import de.bluecolored.shadow.adventure.adventure.text.event.HoverEventSource;
import de.bluecolored.shadow.adventure.adventure.text.format.StyleSetter;

public class RenderThreadsRunningCheck
implements Check {
    private final Plugin plugin;

    @Override
    public CheckResult getResult() {
        return this.plugin.getRenderManager().isRunning() ? CheckResult.OK : CheckResult.BAD;
    }

    @Override
    public Component getFailureDescription() {
        if (this.plugin.checkPausedByPlayerCount()) {
            return TextFormat.lines(Component.text("\u26a0 render-threads are paused"), Component.text("there are too many players online for rendering"), Component.empty(), TextFormat.format("this threshold can be configured in the %", this.formatConfigFilePath("plugin").color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.BASE_COLOR));
        }
        return TextFormat.lines(Component.text("\u26a0 render-threads are stopped"), Component.empty(), TextFormat.format("you can use % to start them", TextFormat.command("/bluemap start").color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.BASE_COLOR));
    }

    private Component formatConfigFilePath(String name) {
        StyleSetter<Component> format = Component.text(name + ".conf");
        BlueMapConfiguration blueMapConfiguration = this.plugin.getBlueMap().getConfig();
        if (blueMapConfiguration instanceof BlueMapConfigManager) {
            BlueMapConfigManager configManager = (BlueMapConfigManager)blueMapConfiguration;
            format = format.hoverEvent((HoverEventSource)Component.text(BlueMapConfigManager.formatPath(configManager.getConfigManager().resolveConfigFile(name))));
        }
        return format;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public RenderThreadsRunningCheck(Plugin plugin) {
        this.plugin = plugin;
    }
}

