/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.api;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.BlueMapWorld;
import de.bluecolored.bluemap.api.RenderManager;
import de.bluecolored.bluemap.api.WebApp;
import de.bluecolored.bluemap.api.plugin.Plugin;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;

public abstract class BlueMapAPI {
    private static final String VERSION;
    private static final String GIT_HASH;
    private static BlueMapAPI instance;
    private static final LinkedHashSet<Consumer<BlueMapAPI>> onEnableConsumers;
    private static final LinkedHashSet<Consumer<BlueMapAPI>> onDisableConsumers;

    public abstract RenderManager getRenderManager();

    public abstract WebApp getWebApp();

    public abstract Plugin getPlugin();

    public abstract Collection<BlueMapMap> getMaps();

    public abstract Collection<BlueMapWorld> getWorlds();

    public abstract Optional<BlueMapWorld> getWorld(Object var1);

    public abstract Optional<BlueMapMap> getMap(String var1);

    public abstract String getBlueMapVersion();

    public String getAPIVersion() {
        return VERSION;
    }

    public static synchronized Optional<BlueMapAPI> getInstance() {
        return Optional.ofNullable(instance);
    }

    public static synchronized void onEnable(Consumer<BlueMapAPI> consumer) {
        onEnableConsumers.add(consumer);
        if (instance != null) {
            consumer.accept(instance);
        }
    }

    public static synchronized void onDisable(Consumer<BlueMapAPI> consumer) {
        onDisableConsumers.add(consumer);
    }

    public static synchronized boolean unregisterListener(Consumer<BlueMapAPI> consumer) {
        return onEnableConsumers.remove(consumer) | onDisableConsumers.remove(consumer);
    }

    @ApiStatus.Internal
    protected static synchronized boolean registerInstance(BlueMapAPI instance) throws Exception {
        if (BlueMapAPI.instance != null) {
            return false;
        }
        BlueMapAPI.instance = instance;
        ArrayList<Exception> thrownExceptions = new ArrayList<Exception>(0);
        for (Consumer consumer : onEnableConsumers) {
            try {
                consumer.accept(BlueMapAPI.instance);
            }
            catch (Exception ex) {
                thrownExceptions.add(ex);
            }
        }
        return BlueMapAPI.throwAsOne(thrownExceptions);
    }

    @ApiStatus.Internal
    protected static synchronized boolean unregisterInstance(BlueMapAPI instance) throws Exception {
        if (BlueMapAPI.instance != instance) {
            return false;
        }
        ArrayList<Exception> thrownExceptions = new ArrayList<Exception>(0);
        for (Consumer consumer : onDisableConsumers) {
            try {
                consumer.accept(BlueMapAPI.instance);
            }
            catch (Exception ex) {
                thrownExceptions.add(ex);
            }
        }
        BlueMapAPI.instance = null;
        return BlueMapAPI.throwAsOne(thrownExceptions);
    }

    private static boolean throwAsOne(List<Exception> thrownExceptions) throws Exception {
        if (!thrownExceptions.isEmpty()) {
            Exception ex = thrownExceptions.get(0);
            for (int i = 1; i < thrownExceptions.size(); ++i) {
                ex.addSuppressed(thrownExceptions.get(i));
            }
            throw ex;
        }
        return true;
    }

    static {
        String version = "DEV";
        String gitHash = "DEV";
        URL url = BlueMapAPI.class.getResource("/de/bluecolored/bluemap/api/version.json");
        if (url != null) {
            Gson gson = new Gson();
            try (InputStream in = url.openStream();
                 InputStreamReader reader = new InputStreamReader(in);){
                JsonObject element = ((JsonElement)gson.fromJson((Reader)reader, JsonElement.class)).getAsJsonObject();
                version = element.get("version").getAsString();
                gitHash = element.get("git-hash").getAsString();
            }
            catch (Exception ex) {
                System.err.println("Failed to load version from resources!");
                ex.printStackTrace();
            }
        }
        if (version.equals("${version}")) {
            version = "DEV";
        }
        if (gitHash.equals("${gitHash}")) {
            version = "DEV";
        }
        VERSION = version;
        GIT_HASH = gitHash;
        onEnableConsumers = new LinkedHashSet();
        onDisableConsumers = new LinkedHashSet();
    }
}

