/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluecommands;

import de.bluecolored.bluecommands.ArgumentCommand;
import de.bluecolored.bluecommands.CommandSetupException;
import de.bluecolored.bluecommands.LiteralCommand;
import de.bluecolored.bluecommands.MethodCommandExecutable;
import de.bluecolored.bluecommands.annotations.Argument;
import de.bluecolored.bluecommands.annotations.Command;
import de.bluecolored.bluecommands.annotations.Parser;
import de.bluecolored.bluecommands.annotations.ParserType;
import de.bluecolored.bluecommands.annotations.Pattern;
import de.bluecolored.bluecommands.annotations.Range;
import de.bluecolored.bluecommands.parsers.ArgumentParser;
import de.bluecolored.bluecommands.parsers.BooleanArgumentParser;
import de.bluecolored.bluecommands.parsers.NumberArgumentParser;
import de.bluecolored.bluecommands.parsers.StringArgumentParser;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import org.jetbrains.annotations.Nullable;

public class BlueCommands<C> {
    private static final java.util.regex.Pattern ARGUMENT_PATTERN = java.util.regex.Pattern.compile("^<(.*)>$");
    private static final java.util.regex.Pattern OPTIONAL_ARGUMENT_PATTERN = java.util.regex.Pattern.compile("^\\[(.*)]$");
    private final Map<String, ArgumentParser<C, ?>> argumentParsersById = new ConcurrentHashMap();
    private final Map<Class<? extends ArgumentParser<C, ?>>, ArgumentParser<C, ?>> argumentParsersByType = new ConcurrentHashMap();
    private final Map<Class<?>, ArgumentParser<C, ?>> argumentParsersByArgumentType = new ConcurrentHashMap();
    private final Map<Class<?>, Function<C, ?>> contextResolvers = new ConcurrentHashMap();
    private final Map<Class<? extends Annotation>, BiPredicate<? extends Annotation, C>> annotationContextPredicate = new ConcurrentHashMap<Class<? extends Annotation>, BiPredicate<? extends Annotation, C>>();

    public BlueCommands() {
        this.setArgumentParserForArgumentType(String.class, StringArgumentParser.string());
        this.setArgumentParserForArgumentType(Byte.TYPE, NumberArgumentParser.forBytes());
        this.setArgumentParserForArgumentType(Byte.class, NumberArgumentParser.forBytes());
        this.setArgumentParserForArgumentType(Short.TYPE, NumberArgumentParser.forShorts());
        this.setArgumentParserForArgumentType(Short.class, NumberArgumentParser.forShorts());
        this.setArgumentParserForArgumentType(Integer.TYPE, NumberArgumentParser.forIntegers());
        this.setArgumentParserForArgumentType(Integer.class, NumberArgumentParser.forIntegers());
        this.setArgumentParserForArgumentType(Long.TYPE, NumberArgumentParser.forLongs());
        this.setArgumentParserForArgumentType(Long.class, NumberArgumentParser.forLongs());
        this.setArgumentParserForArgumentType(Float.TYPE, NumberArgumentParser.forFloats());
        this.setArgumentParserForArgumentType(Float.class, NumberArgumentParser.forFloats());
        this.setArgumentParserForArgumentType(Double.TYPE, NumberArgumentParser.forDoubles());
        this.setArgumentParserForArgumentType(Double.class, NumberArgumentParser.forDoubles());
        this.setArgumentParserForArgumentType(Boolean.TYPE, BooleanArgumentParser.create());
        this.setArgumentParserForArgumentType(Boolean.class, BooleanArgumentParser.create());
    }

    public de.bluecolored.bluecommands.Command<C, Object> createCommand(Object holder) {
        de.bluecolored.bluecommands.Command<C, Object> root = new de.bluecolored.bluecommands.Command<C, Object>();
        Class<?> holderClass = holder.getClass();
        String[] descriptionPrefixes = new String[]{""};
        Command holderCommand = holderClass.getAnnotation(Command.class);
        if (holderCommand != null) {
            descriptionPrefixes = holderCommand.value();
        }
        for (String descriptionPrefix : descriptionPrefixes) {
            for (Method method : holderClass.getDeclaredMethods()) {
                Command command = method.getAnnotation(Command.class);
                if (command == null) continue;
                for (String description : command.value()) {
                    root.addSubCommand(this.createCommand(holder, method, descriptionPrefix + " " + description));
                }
            }
        }
        return root;
    }

    private de.bluecolored.bluecommands.Command<C, Object> createCommand(Object holder, Method method, String description) {
        String[] tokens = description.isBlank() ? new String[]{} : description.trim().split(" +");
        try {
            return this.createCommand(holder, method, tokens, 0);
        }
        catch (CommandSetupException ex) {
            throw new CommandSetupException(ex.getMessage() + "\nMethod: " + method, ex);
        }
    }

    private de.bluecolored.bluecommands.Command<C, Object> createCommand(Object holder, Method method, String[] tokens, int nextToken) {
        de.bluecolored.bluecommands.Command command;
        if (nextToken >= tokens.length) {
            de.bluecolored.bluecommands.Command command2 = new de.bluecolored.bluecommands.Command();
            command2.setExecutable(new MethodCommandExecutable(method, holder, this));
            return command2;
        }
        String token = tokens[nextToken];
        boolean optional = false;
        Matcher argumentMatcher = ARGUMENT_PATTERN.matcher(token);
        if (!argumentMatcher.matches()) {
            argumentMatcher = OPTIONAL_ARGUMENT_PATTERN.matcher(token);
            optional = true;
        }
        if (!argumentMatcher.matches()) {
            command = new LiteralCommand<C, Object>(token);
        } else {
            Range range;
            Pattern pattern;
            String argumentId = argumentMatcher.group(1);
            Parameter parameter = null;
            for (Parameter param : method.getParameters()) {
                Argument argument = param.getAnnotation(Argument.class);
                if (argument == null || !argument.value().equals(argumentId)) continue;
                parameter = param;
                break;
            }
            if (parameter == null) {
                throw new CommandSetupException(String.format("Argument '%s' is missing in method-signature.", argumentId));
            }
            Parser parser = parameter.getAnnotation(Parser.class);
            ParserType parserType = parameter.getAnnotation(ParserType.class);
            ArgumentParser<C, Object> argumentParser = parser != null ? this.getArgumentParser(parser.value()) : (parserType != null ? this.getArgumentParser(parserType.value()) : this.getParserByArgumentType(parameter.getType()));
            if (argumentParser == null) {
                throw new CommandSetupException(String.format("No Argument-Parser found for Argument '%s'.", argumentId));
            }
            if (argumentParser.getClass() == StringArgumentParser.class && (pattern = parameter.getAnnotation(Pattern.class)) != null) {
                StringArgumentParser stringArgumentParser = (StringArgumentParser)argumentParser;
                argumentParser = stringArgumentParser.withPattern(pattern.value());
            }
            if (argumentParser.getClass() == NumberArgumentParser.class && (range = parameter.getAnnotation(Range.class)) != null) {
                NumberArgumentParser numberArgumentParser = (NumberArgumentParser)argumentParser;
                argumentParser = numberArgumentParser.withBounds(range.min(), range.max());
            }
            command = new ArgumentCommand(argumentId, argumentParser, optional);
        }
        command.addSubCommand(this.createCommand(holder, method, tokens, nextToken + 1));
        return command;
    }

    public void setArgumentParserForId(String id, ArgumentParser<C, ?> argumentParser) {
        this.argumentParsersById.put(id, argumentParser);
    }

    public <T> void setArgumentParserForArgumentType(Class<T> type, ArgumentParser<C, ? extends T> argumentParser) {
        this.argumentParsersByArgumentType.put(type, argumentParser);
    }

    public <T> void setContextResolverForType(Class<T> type, Function<C, T> contextResolver) {
        this.contextResolvers.put(type, contextResolver);
    }

    public void setContextPredicate(Predicate<C> contextPredicate) {
        this.setAnnotationContextPredicate(null, (command, context) -> contextPredicate.test(context));
    }

    public <A extends Annotation> void setAnnotationContextPredicate(Class<A> annotationType, BiPredicate<@Nullable A, C> contextPredicate) {
        this.annotationContextPredicate.put(annotationType, contextPredicate);
    }

    @Nullable
    public <T> ArgumentParser<C, ? extends T> getParserByArgumentType(Class<T> argumentType) {
        return this.argumentParsersByArgumentType.get(argumentType);
    }

    public <T> ArgumentParser<C, T> getArgumentParser(Class<? extends ArgumentParser<C, T>> parserType) {
        return this.argumentParsersByType.computeIfAbsent(parserType, type -> {
            try {
                Constructor constructor = type.getConstructor(new Class[0]);
                constructor.setAccessible(true);
                return (ArgumentParser)constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new CommandSetupException("Failed to create an instance of: " + parserType, e);
            }
        });
    }

    @Nullable
    public ArgumentParser<C, ?> getArgumentParser(String id) {
        return this.argumentParsersById.get(id);
    }

    @Nullable
    public <T> Function<C, T> getContextResolver(Class<T> argumentType) {
        return this.contextResolvers.get(argumentType);
    }

    @Nullable
    public <A extends Annotation> @Nullable BiPredicate<@Nullable A, C> getAnnotationContextPredicate(Class<A> annotationType) {
        return this.annotationContextPredicate.get(annotationType);
    }

    public boolean checkContext(C context) {
        for (BiPredicate<Annotation, C> predicate : this.annotationContextPredicate.values()) {
            if (predicate.test(null, context)) continue;
            return false;
        }
        return true;
    }

    public boolean checkContext(C context, Method method) {
        for (Map.Entry<Class<Annotation>, BiPredicate<Annotation, C>> entry : this.annotationContextPredicate.entrySet()) {
            Annotation annotation;
            Class<? extends Annotation> annotationType = entry.getKey();
            Annotation annotation2 = annotation = annotationType != null ? method.getAnnotation(entry.getKey()) : null;
            BiPredicate<Annotation, C> predicate = entry.getValue();
            if (predicate.test(annotation, context)) continue;
            return false;
        }
        return true;
    }
}

