/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.mixins.compat.ironfurnaces;

import ironfurnaces.items.augments.ItemAugmentFuel;
import ironfurnaces.items.augments.ItemAugmentSpeed;
import ironfurnaces.tileentity.TileEntityInventory;
import ironfurnaces.tileentity.furnaces.BlockIronFurnaceTileBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.zeith.solarflux.api.IFurnaceBlockEntity;
import org.zeith.solarflux.api.ISolarPanelTile;

@Implements(value={@Interface(iface=IFurnaceBlockEntity.class, prefix="ifbe$")})
@Mixin(value={BlockIronFurnaceTileBase.class})
public abstract class BlockIronFurnaceTileBaseMixin
extends TileEntityInventory {
    @Unique
    private boolean sfr$chargedByPanel;

    @Shadow
    public abstract boolean isFurnace();

    @Shadow
    protected abstract RecipeHolder<? extends AbstractCookingRecipe> getRecipeNonCached(ItemStack var1);

    @Shadow
    protected abstract boolean canSmelt(@Nullable RecipeHolder<?> var1);

    public BlockIronFurnaceTileBaseMixin(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state, int sizeInventory) {
        super(tileEntityTypeIn, pos, state, sizeInventory);
    }

    public boolean ifbe$activateWithSolarPanel(ISolarPanelTile solar) {
        if (this.sfr$chargedByPanel || !this.isFurnace()) {
            return false;
        }
        this.sfr$chargedByPanel = true;
        solar.energy(solar.energy() - 1000L);
        this.setChanged();
        return true;
    }

    public Direction ifbe$getSideForSolarPanel() {
        return this.isFurnace() ? Direction.UP : null;
    }

    @Inject(method={"loadAdditional"}, at={@At(value="HEAD")})
    private void SolarFlux_loadAdditional(CompoundTag tag, HolderLookup.Provider provider, CallbackInfo ci) {
        CompoundTag ct = tag.getCompound("SolarFlux");
        this.sfr$chargedByPanel = ct.getBoolean("Charged");
    }

    @Inject(method={"saveAdditional"}, at={@At(value="HEAD")})
    private void SolarFlux_saveAdditional(CompoundTag tag, HolderLookup.Provider provider, CallbackInfo ci) {
        CompoundTag ct = new CompoundTag();
        ct.putBoolean("Charged", this.sfr$chargedByPanel);
        tag.put("SolarFlux", (Tag)ct);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lironfurnaces/tileentity/furnaces/BlockIronFurnaceTileBase;checkRecipeType()V", ordinal=1)})
    private static void SolarFlux_tickPrepareTarget(Level level, BlockPos worldPosition, BlockState blockState, BlockIronFurnaceTileBase e, CallbackInfo ci) {
        BlockIronFurnaceTileBase te = e;
        BlockIronFurnaceTileBaseMixin mix = (BlockIronFurnaceTileBaseMixin)te;
        assert (mix != null);
        if (!mix.sfr$chargedByPanel || e.isBurning()) {
            return;
        }
        ItemStack inputItem = e.getItem(0);
        if (inputItem.isEmpty()) {
            return;
        }
        if (!mix.canSmelt(mix.getRecipeNonCached(inputItem))) {
            return;
        }
        mix.sfr$chargedByPanel = false;
        int cookTime = e.getCookTime();
        ItemStack upgradeSlot = e.getItem(4);
        if (!upgradeSlot.isEmpty()) {
            if (upgradeSlot.getItem() instanceof ItemAugmentFuel) {
                e.furnaceBurnTime = cookTime * 2;
            } else if (upgradeSlot.getItem() instanceof ItemAugmentSpeed) {
                e.furnaceBurnTime = cookTime / 2;
            }
        } else {
            e.furnaceBurnTime = cookTime;
        }
        e.setChanged();
    }
}

