/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.mixins;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.zeith.solarflux.api.IFurnaceBlockEntity;
import org.zeith.solarflux.api.ISolarPanelTile;

@Implements(value={@Interface(iface=IFurnaceBlockEntity.class, prefix="ifbe$")})
@Mixin(value={AbstractFurnaceBlockEntity.class})
public abstract class AbstractFurnaceBlockEntityMixin
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeCraftingHolder,
StackedContentsCompatible {
    @Shadow
    @Final
    private RecipeType<? extends AbstractCookingRecipe> recipeType;
    @Shadow
    int litTime;
    @Shadow
    int litDuration;
    @Shadow
    @Final
    private RecipeManager.CachedCheck<SingleRecipeInput, ? extends AbstractCookingRecipe> quickCheck;

    protected AbstractFurnaceBlockEntityMixin(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public boolean ifbe$activateWithSolarPanel(ISolarPanelTile solar) {
        BlockPos pos = this.getBlockPos();
        Level lvl = this.getLevel();
        SingleRecipeInput singlerecipeinput = new SingleRecipeInput(this.getItem(0));
        RecipeHolder irecipe = this.quickCheck.getRecipeFor((RecipeInput)singlerecipeinput, lvl).orElse(null);
        if (this.litTime <= 1 && irecipe != null && this.SolarFlux$canSmelt(irecipe.value()) && solar.energy() >= 1000L) {
            this.litTime = 201;
            this.litDuration = 201;
            solar.energy(solar.energy() - 1000L);
            BlockState state = lvl.getBlockState(pos);
            if (state.hasProperty((Property)AbstractFurnaceBlock.LIT) && !((Boolean)state.getValue((Property)AbstractFurnaceBlock.LIT)).booleanValue()) {
                state = (BlockState)state.setValue((Property)AbstractFurnaceBlock.LIT, (Comparable)Boolean.valueOf(true));
                lvl.setBlock(pos, state, 3);
                lvl.blockEntityChanged(pos);
                if (!state.isAir()) {
                    lvl.updateNeighbourForOutputSignal(pos, state.getBlock());
                }
            }
            this.setChanged();
            return true;
        }
        return false;
    }

    public Direction ifbe$getSideForSolarPanel() {
        return Direction.UP;
    }

    @Unique
    private boolean SolarFlux$canSmelt(@Nullable Recipe<?> recipe) {
        if (this.getItem(0).isEmpty() || recipe == null) {
            return false;
        }
        ItemStack result = recipe.getResultItem((HolderLookup.Provider)this.getLevel().registryAccess());
        if (result.isEmpty()) {
            return false;
        }
        ItemStack curResIt = this.getItem(2);
        if (curResIt.isEmpty()) {
            return true;
        }
        if (!ItemStack.isSameItem((ItemStack)curResIt, (ItemStack)result)) {
            return false;
        }
        if (curResIt.getCount() + result.getCount() <= this.getMaxStackSize() && curResIt.getCount() + result.getCount() <= curResIt.getMaxStackSize()) {
            return true;
        }
        return curResIt.getCount() + result.getCount() <= result.getMaxStackSize();
    }
}

