/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.compat.twilightforest;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.zeith.hammerlib.compat.base.BaseCompat;
import org.zeith.hammerlib.compat.base.CompatContext;
import org.zeith.hammerlib.core.adapter.recipe.ShapedRecipeBuilder;
import org.zeith.hammerlib.event.recipe.RegisterRecipesEvent;
import org.zeith.hammerlib.util.mcf.Resources;
import org.zeith.solarflux.SolarFlux;
import org.zeith.solarflux.compat._base.SolarFluxCompat;
import org.zeith.solarflux.compat.twilightforest.ContentsSFTF;
import org.zeith.solarflux.init.ItemsSF;
import org.zeith.solarflux.init.SolarPanelsSF;
import org.zeith.solarflux.panels.SolarPanel;

@BaseCompat.LoadCompat(modid="twilightforest", compatType=SolarFluxCompat.class)
public class TwilightForestCompat
extends SolarFluxCompat {
    public final ResourceLocation fieryRecipe = SolarFlux.id("solar_panels/twilightforest/fiery");
    public final ResourceLocation carminiteRecipe = SolarFlux.id("solar_panels/twilightforest/carminite");
    public final ResourceLocation twiCell1Recipe = SolarFlux.id("twilightforest/twilight_cell_1");
    public final ResourceLocation twiCell2Recipe = SolarFlux.id("twilightforest/twilight_cell_2");
    public final ResourceLocation twiLightUpgradeRecipe = SolarFlux.id("twilightforest/twilight_upgrade");
    private SolarPanel fiery;
    private SolarPanel carminite;

    public TwilightForestCompat(CompatContext ctx) {
        super(ctx, ContentsSFTF.class);
    }

    @Override
    public void registerSolarPanels(Supplier<SolarPanel.Builder> factory, Function<SolarPanel.Builder, SolarPanel> registrar) {
        this.fiery = registrar.apply(factory.get().name("tf.fiery").copyEnergy(SolarPanelsSF.CORE_PANELS[5]));
        this.carminite = registrar.apply(factory.get().name("tf.carminite").copyEnergy(SolarPanelsSF.CORE_PANELS[6]));
    }

    @Override
    public void indexRecipes(Consumer<ResourceLocation> recipes) {
        recipes.accept(this.fieryRecipe);
        recipes.accept(this.carminiteRecipe);
        recipes.accept(this.twiCell1Recipe);
        recipes.accept(this.twiCell2Recipe);
        recipes.accept(this.twiLightUpgradeRecipe);
    }

    @Override
    public void registerRecipes(RegisterRecipesEvent e) {
        TagKey fieryBlock = ItemTags.create((ResourceLocation)Resources.location((String)"c", (String)"storage_blocks/fiery"));
        TagKey carminiteItem = ItemTags.create((ResourceLocation)Resources.location((String)"c", (String)"gems/carminite"));
        TagKey ironwoodBlock = ItemTags.create((ResourceLocation)Resources.location((String)"c", (String)"storage_blocks/ironwood"));
        TagKey ironwoodIngot = ItemTags.create((ResourceLocation)Resources.location((String)"c", (String)"ingots/ironwood"));
        TagKey fieryIngot = ItemTags.create((ResourceLocation)Resources.location((String)"c", (String)"ingots/fiery"));
        TagKey knightmetal = ItemTags.create((ResourceLocation)Resources.location((String)"c", (String)"ingots/knightmetal"));
        TagKey steeleaf = ItemTags.create((ResourceLocation)Resources.location((String)"c", (String)"ingots/steeleaf"));
        Item torchberries = (Item)BuiltInRegistries.ITEM.get(Resources.location((String)"twilightforest", (String)"torchberries"));
        ((ShapedRecipeBuilder)((ShapedRecipeBuilder)e.shaped().id(this.twiLightUpgradeRecipe)).result((ItemLike)ContentsSFTF.TWI_LIGHT_UPGRADE)).shape(new String[]{"ici", "tbt", "iti"}).map('i', (Object)ironwoodIngot).map('c', (Object)Items.CLOCK).map('t', (Object)torchberries).map('b', (Object)ItemsSF.EFFICIENCY_UPGRADE).registerIf(SolarPanelsSF::isRecipeActive);
        ((ShapedRecipeBuilder)((ShapedRecipeBuilder)e.shaped().id(this.twiCell1Recipe)).result((ItemLike)ContentsSFTF.TWILIGHT_CELL_1, 2)).shape(new String[]{"bbb", "gdg", "qcq"}).map('b', (Object)ItemsSF.BLAZING_COATING).map('g', (Object)fieryIngot).map('d', (Object)steeleaf).map('q', (Object)ironwoodBlock).map('c', (Object)ItemsSF.PHOTOVOLTAIC_CELL_3).registerIf(SolarPanelsSF::isRecipeActive);
        ((ShapedRecipeBuilder)((ShapedRecipeBuilder)e.shaped().id(this.twiCell2Recipe)).result((ItemLike)ContentsSFTF.TWILIGHT_CELL_2, 3)).shape(new String[]{"bbb", "gdg", "cqc"}).map('b', (Object)ItemsSF.EMERALD_GLASS).map('g', (Object)fieryBlock).map('d', (Object)carminiteItem).map('q', (Object)knightmetal).map('c', (Object)ContentsSFTF.TWILIGHT_CELL_1).registerIf(SolarPanelsSF::isRecipeActive);
        ((ShapedRecipeBuilder)((ShapedRecipeBuilder)e.shaped().id(this.fieryRecipe)).result((ItemLike)this.fiery, 2)).shape(new String[]{"ppp", "scs", "sbs"}).map('s', (Object)SolarPanelsSF.getGeneratingSolars(SolarPanelsSF.CORE_PANELS[4])).map('p', (Object)ContentsSFTF.TWILIGHT_CELL_1).map('c', (Object)torchberries).map('b', (Object)fieryBlock).registerIf(SolarPanelsSF::isRecipeActive);
        ((ShapedRecipeBuilder)((ShapedRecipeBuilder)e.shaped().id(this.carminiteRecipe)).result((ItemLike)this.carminite, 2)).shape(new String[]{"ppp", "scs", "scs"}).map('s', (Object)this.fiery).map('p', (Object)ContentsSFTF.TWILIGHT_CELL_2).map('c', (Object)carminiteItem).registerIf(SolarPanelsSF::isRecipeActive);
    }
}

