/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.compat.draconicevolution;

import com.brandon3055.brandonscore.api.TechLevel;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.zeith.hammerlib.compat.base.BaseCompat;
import org.zeith.hammerlib.compat.base.CompatContext;
import org.zeith.hammerlib.core.adapter.recipe.ShapedRecipeBuilder;
import org.zeith.hammerlib.event.recipe.RegisterRecipesEvent;
import org.zeith.hammerlib.util.mcf.Resources;
import org.zeith.solarflux.SolarFlux;
import org.zeith.solarflux.compat._base.SolarFluxCompat;
import org.zeith.solarflux.compat.draconicevolution.FusionRecipeAPI;
import org.zeith.solarflux.init.SolarPanelsSF;
import org.zeith.solarflux.panels.SolarPanel;

@BaseCompat.LoadCompat(modid="draconicevolution", compatType=SolarFluxCompat.class)
public class DraconicEvolutionCompat
extends SolarFluxCompat {
    public final ResourceLocation wyvernRecipe = SolarFlux.id("solar_panels/draconicevolution/wyvern");
    public final ResourceLocation draconicRecipe = SolarFlux.id("solar_panels/draconicevolution/draconic");
    public final ResourceLocation chaoticRecipe = SolarFlux.id("solar_panels/draconicevolution/chaotic");
    public SolarPanel wyvern;
    public SolarPanel draconic;
    public SolarPanel chaotic;

    public DraconicEvolutionCompat(CompatContext ctx) {
        super(ctx, new Class[0]);
    }

    @Override
    public void registerSolarPanels(Supplier<SolarPanel.Builder> factory, Function<SolarPanel.Builder, SolarPanel> registrar) {
        this.wyvern = registrar.apply(factory.get().name("de.wyvern").generation(65536).transfer(512000L).capacity(256000000L));
        this.draconic = registrar.apply(factory.get().name("de.draconic").generation(262144).transfer(1024000L).capacity(512000000L));
        this.chaotic = registrar.apply(factory.get().name("de.chaotic").generation(524288).transfer(4096000L).capacity(2048000000L));
    }

    @Override
    public void indexRecipes(Consumer<ResourceLocation> recipes) {
        recipes.accept(this.wyvernRecipe);
        recipes.accept(this.draconicRecipe);
        recipes.accept(this.chaoticRecipe);
    }

    @Override
    public void registerRecipes(RegisterRecipesEvent e) {
        try {
            Function<String, Item> items = id -> (Item)BuiltInRegistries.ITEM.get(Resources.location((String)"draconicevolution", (String)id));
            Item chaoticCore = items.apply("chaotic_core");
            Item awakenedCore = items.apply("awakened_core");
            Item wyvernEnergyCore = items.apply("wyvern_energy_core");
            Item wyvernCore = items.apply("wyvern_core");
            Item draconicEnergyCore = items.apply("draconic_energy_core");
            ((ShapedRecipeBuilder)((ShapedRecipeBuilder)e.shaped().id(this.wyvernRecipe)).result((ItemLike)this.wyvern, 2)).shape(new String[]{"sps", "pcp", "sps"}).map('s', (Object)SolarPanelsSF.getGeneratingSolars(SolarPanelsSF.CORE_PANELS[7])).map('p', (Object)new ItemStack((ItemLike)wyvernEnergyCore)).map('c', (Object)new ItemStack((ItemLike)wyvernCore)).registerIf(SolarPanelsSF::isRecipeActive);
            ((ShapedRecipeBuilder)((ShapedRecipeBuilder)e.shaped().id(this.draconicRecipe)).result((ItemLike)this.draconic, 2)).shape(new String[]{"sps", "pcp", "sps"}).map('s', (Object)SolarPanelsSF.getGeneratingSolars(this.wyvern)).map('p', (Object)new ItemStack((ItemLike)draconicEnergyCore)).map('c', (Object)new ItemStack((ItemLike)awakenedCore)).registerIf(SolarPanelsSF::isRecipeActive);
            if (SolarPanelsSF.isRecipeActive(this.chaoticRecipe)) {
                FusionRecipeAPI.register(this.chaoticRecipe, FusionRecipeAPI.create(new ItemStack((ItemLike)this.chaotic.getBlock(), 4), Ingredient.of((ItemLike[])new ItemLike[]{chaoticCore}), 256000000L, TechLevel.CHAOTIC, List.of(FusionRecipeAPI.ingr(new ItemStack((ItemLike)awakenedCore)), FusionRecipeAPI.ingr(SolarPanelsSF.getGeneratingSolars(this.draconic)), FusionRecipeAPI.ingr(new ItemStack((ItemLike)awakenedCore)), FusionRecipeAPI.ingr(SolarPanelsSF.getGeneratingSolars(this.draconic)), FusionRecipeAPI.ingr(new ItemStack((ItemLike)awakenedCore)), FusionRecipeAPI.ingr(SolarPanelsSF.getGeneratingSolars(this.draconic)), FusionRecipeAPI.ingr(new ItemStack((ItemLike)awakenedCore)), FusionRecipeAPI.ingr(SolarPanelsSF.getGeneratingSolars(this.draconic)))), e);
            }
        }
        catch (LinkageError | ReflectiveOperationException error) {
            SolarFlux.LOG.error("Failed to register DraconicEvolution recipes!", error);
        }
    }
}

