/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.client;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.client.model.IBakedModel;
import org.zeith.hammerlib.client.model.IUnbakedGeometry;
import org.zeith.hammerlib.client.model.LoadUnbakedGeometry;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.mcf.Resources;
import org.zeith.solarflux.block.SolarPanelBlock;
import org.zeith.solarflux.client.SolarPanelBakedModel;
import org.zeith.solarflux.client.SolarPanelModelData;

@LoadUnbakedGeometry(path="solar_panel")
public class SolarPanelItemModel
implements IUnbakedGeometry<SolarPanelItemModel> {
    final SolarPanelBlock block;
    Material baseTx;
    Material topTx;

    public SolarPanelItemModel(JsonObject obj, JsonDeserializationContext context) {
        this.block = (SolarPanelBlock)((Object)Cast.optionally((Object)BuiltInRegistries.BLOCK.get(Resources.location((String)GsonHelper.getAsString((JsonObject)obj, (String)"panel"))), SolarPanelBlock.class).orElseThrow(() -> new JsonSyntaxException("Unable to find solar panel block by id '" + GsonHelper.getAsString((JsonObject)obj, (String)"panel") + "'")));
        ResourceLocation registryName = BuiltInRegistries.BLOCK.getKey((Object)this.block);
        this.baseTx = new Material(InventoryMenu.BLOCK_ATLAS, Resources.location((String)registryName.getNamespace(), (String)("block/" + registryName.getPath() + "_base")));
        this.topTx = new Material(InventoryMenu.BLOCK_ATLAS, Resources.location((String)registryName.getNamespace(), (String)("block/" + registryName.getPath() + "_top")));
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides) {
        return new Baked(this.block, spriteGetter.apply(this.topTx), spriteGetter.apply(this.baseTx));
    }

    private static class Baked
    implements IBakedModel {
        public static final FaceBakery COOKER = new FaceBakery();
        public final SolarPanelBlock block;
        public final TextureAtlasSprite top;
        public final TextureAtlasSprite base;
        final RandomSource rng = RandomSource.create();

        public Baked(SolarPanelBlock block, TextureAtlasSprite top, TextureAtlasSprite base) {
            this.block = block;
            this.top = top;
            this.base = base;
        }

        @NotNull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction sideIn, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
            Direction[] directionArray;
            SolarPanelModelData spmd = SolarPanelModelData.findOrItem(data);
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            if (sideIn == null) {
                directionArray = Direction.values();
            } else {
                Direction[] directionArray2 = new Direction[1];
                directionArray = directionArray2;
                directionArray2[0] = sideIn;
            }
            Direction[] sides = directionArray;
            float h = this.block.panel.getPanelData().height * 16.0f;
            for (Direction side : sides) {
                if (side == null) continue;
                SolarPanelBakedModel.createSolarPanelQuads(quads, side, h, this.top, this.base, spmd);
            }
            return quads;
        }

        public boolean useAmbientOcclusion() {
            return false;
        }

        public boolean isGui3d() {
            return false;
        }

        public boolean usesBlockLight() {
            return true;
        }

        public boolean isCustomRenderer() {
            return false;
        }

        public TextureAtlasSprite getParticleIcon() {
            return this.rng.nextInt(3) == 0 ? this.top : this.base;
        }
    }
}

