/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.api.blocks.ICustomBlockItem;
import org.zeith.hammerlib.api.fml.IRegisterListener;
import org.zeith.hammerlib.api.forge.BlockAPI;
import org.zeith.hammerlib.api.forge.ContainerAPI;
import org.zeith.hammerlib.core.adapter.BlockEntityAdapter;
import org.zeith.hammerlib.core.adapter.BlockHarvestAdapter;
import org.zeith.solarflux.block.SolarPanelBlockItem;
import org.zeith.solarflux.block.SolarPanelTile;
import org.zeith.solarflux.init.TilesSF;
import org.zeith.solarflux.items.upgrades._base.UpgradeItem;
import org.zeith.solarflux.panels.SolarPanel;

public class SolarPanelBlock
extends BaseEntityBlock
implements ICustomBlockItem,
IRegisterListener {
    public final SolarPanel panel;
    public final MapCodec<SolarPanelBlock> CODEC;

    public SolarPanelBlock(SolarPanel panel, BlockBehaviour.Properties properties) {
        super(properties);
        this.bindTool();
        this.panel = panel;
        this.CODEC = SolarPanelBlock.simpleCodec(props -> new SolarPanelBlock(panel, (BlockBehaviour.Properties)props));
    }

    public void onPostRegistered(ResourceLocation id) {
        BlockEntityAdapter.addBlocksToEntityType(TilesSF.SOLAR_PANEL, (Block[])new Block[]{this});
        super.onPostRegistered(id);
    }

    protected void bindTool() {
        BlockHarvestAdapter.bindTool((BlockHarvestAdapter.MineableType)BlockHarvestAdapter.MineableType.PICKAXE, (Tiers)Tiers.IRON, (Block[])new Block[]{this});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return BlockAPI.ticker();
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        NonNullList stacks = NonNullList.create();
        BlockEntity tileentity = (BlockEntity)builder.getParameter(LootContextParams.BLOCK_ENTITY);
        if (tileentity instanceof SolarPanelTile) {
            SolarPanelTile te = (SolarPanelTile)tileentity;
            stacks.add((Object)te.generateItem(this.panel));
        } else {
            stacks.add((Object)new ItemStack((ItemLike)this.panel));
        }
        return stacks;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return this.CODEC;
    }

    public RenderShape getRenderShape(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof SolarPanelTile) {
            SolarPanelTile spt = (SolarPanelTile)blockEntity;
            return spt.getShape(this);
        }
        return Shapes.create((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)this.panel.getPanelData().height, (double)1.0);
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, worldIn, pos, blockIn, fromPos, isMoving);
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (blockEntity instanceof SolarPanelTile) {
            SolarPanelTile spt = (SolarPanelTile)blockEntity;
            spt.resetVoxelShape();
        }
    }

    public VoxelShape recalcShape(BlockGetter world, BlockPos pos) {
        SolarPanel.SolarPanelData pd = this.panel.getPanelData();
        float ph = pd.height;
        VoxelShape baseShape = Shapes.create((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)ph, (double)1.0);
        Stream.Builder<VoxelShape> shapes = Stream.builder();
        boolean west = false;
        boolean east = false;
        boolean north = false;
        boolean south = false;
        float h = ph;
        float h2 = h + 0.015625f;
        west = world.getBlockState(pos.west()).getBlock() != this;
        if (west) {
            shapes.add(Shapes.create((double)0.0, (double)h, (double)0.0625, (double)0.0625, (double)h2, (double)0.9375));
        }
        if (east = world.getBlockState(pos.east()).getBlock() != this) {
            shapes.add(Shapes.create((double)0.9375, (double)h, (double)0.0625, (double)1.0, (double)h2, (double)0.9375));
        }
        if (north = world.getBlockState(pos.north()).getBlock() != this) {
            shapes.add(Shapes.create((double)0.0625, (double)h, (double)0.0, (double)0.9375, (double)h2, (double)0.0625));
        }
        if (south = world.getBlockState(pos.south()).getBlock() != this) {
            shapes.add(Shapes.create((double)0.0625, (double)h, (double)0.9375, (double)0.9375, (double)h2, (double)1.0));
        }
        if (west || north || world.getBlockState(pos.west().north()).getBlock() != this) {
            shapes.add(Shapes.create((double)0.0, (double)h, (double)0.0, (double)0.0625, (double)h2, (double)0.0625));
        }
        if (east || north || world.getBlockState(pos.east().north()).getBlock() != this) {
            shapes.add(Shapes.create((double)0.9375, (double)h, (double)0.0, (double)1.0, (double)h2, (double)0.0625));
        }
        if (south || east || world.getBlockState(pos.south().east()).getBlock() != this) {
            shapes.add(Shapes.create((double)0.9375, (double)h, (double)0.9375, (double)1.0, (double)h2, (double)1.0));
        }
        if (west || south || world.getBlockState(pos.west().south()).getBlock() != this) {
            shapes.add(Shapes.create((double)0.0, (double)h, (double)0.9375, (double)0.0625, (double)h2, (double)1.0));
        }
        return Shapes.or((VoxelShape)baseShape, (VoxelShape[])((VoxelShape[])shapes.build().toArray(VoxelShape[]::new)));
    }

    protected ItemInteractionResult useItemOn(ItemStack held, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand p_316595_, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (player instanceof ServerPlayer && (blockEntity = worldIn.getBlockEntity(pos)) instanceof SolarPanelTile) {
            UpgradeItem iu;
            int amt;
            SolarPanelTile tbs = (SolarPanelTile)blockEntity;
            if (!held.isEmpty() && (blockEntity = held.getItem()) instanceof UpgradeItem && (amt = tbs.getUpgrades(iu = (UpgradeItem)blockEntity)) < iu.getMaxUpgradesInstalled(tbs) && iu.canInstall(tbs, held, tbs.upgradeInventory)) {
                int installed = 0;
                for (int i = 0; i < tbs.upgradeInventory.getSlots(); ++i) {
                    ItemStack stack = tbs.upgradeInventory.getStackInSlot(i);
                    if (ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)held)) {
                        int allow = Math.min(iu.getMaxUpgradesInstalled(tbs) - tbs.getUpgrades(iu), Math.min(iu.getMaxStackSize(stack) - stack.getCount(), held.getCount()));
                        stack.grow(allow);
                        held.shrink(allow);
                        installed += allow;
                        break;
                    }
                    if (!stack.isEmpty()) continue;
                    int allow = Math.min(iu.getMaxUpgradesInstalled(tbs) - tbs.getUpgrades(iu), held.getCount());
                    ItemStack copy = held.copy();
                    held.shrink(allow);
                    copy.setCount(allow);
                    tbs.upgradeInventory.setStackInSlot(i, copy);
                    installed += allow;
                    break;
                }
                if (installed > 0) {
                    iu.onInstalled(tbs, amt, tbs.getUpgrades(iu));
                    worldIn.playSound(null, pos, SoundEvents.ANVIL_LAND, SoundSource.BLOCKS, 0.1f, 1.0f);
                    return ItemInteractionResult.SUCCESS;
                }
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (player instanceof ServerPlayer && (blockEntity = worldIn.getBlockEntity(pos)) instanceof SolarPanelTile) {
            SolarPanelTile tbs = (SolarPanelTile)blockEntity;
            ContainerAPI.openContainerTile((Player)player, (BlockEntity)tbs);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean hasAnalogOutputSignal(BlockState p_60457_) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level worldIn, BlockPos pos) {
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (blockEntity instanceof SolarPanelTile) {
            SolarPanelTile sp = (SolarPanelTile)blockEntity;
            long cap = sp.capacity.getValueL();
            return cap > 0L ? (int)Math.round(15.0 * (double)sp.energy / (double)cap) : 0;
        }
        return 0;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        SolarPanelTile tile = new SolarPanelTile(pos, state);
        tile.setDelegate(this.panel);
        return tile;
    }

    public boolean propagatesSkylightDown(BlockState p_49928_, BlockGetter p_49929_, BlockPos p_49930_) {
        return false;
    }

    public BlockItem createBlockItem() {
        return new SolarPanelBlockItem(this, new Item.Properties());
    }
}

