/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackResources;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeith.hammerlib.api.items.CreativeTab;
import org.zeith.hammerlib.api.proxy.IProxy;
import org.zeith.hammerlib.client.adapter.ResourcePackAdapter;
import org.zeith.hammerlib.compat.base.CompatContext;
import org.zeith.hammerlib.compat.base.CompatList;
import org.zeith.hammerlib.core.adapter.LanguageAdapter;
import org.zeith.hammerlib.event.fml.FMLFingerprintCheckEvent;
import org.zeith.hammerlib.proxy.HLConstants;
import org.zeith.hammerlib.util.CommonMessages;
import org.zeith.hammerlib.util.mcf.Resources;
import org.zeith.solarflux.RecipesSF;
import org.zeith.solarflux.client.SolarFluxResourcePack;
import org.zeith.solarflux.client.SolarPanelBakedModel;
import org.zeith.solarflux.compat._base.SFCompatList;
import org.zeith.solarflux.compat._base.SolarFluxCompat;
import org.zeith.solarflux.init.ItemsSF;
import org.zeith.solarflux.init.SolarPanelsSF;
import org.zeith.solarflux.net.PacketSyncPanelData;
import org.zeith.solarflux.proxy.SFRClientProxy;
import org.zeith.solarflux.proxy.SFRCommonProxy;

@Mod(value="solarflux")
public class SolarFlux {
    public static final String MOD_ID = "solarflux";
    public static final Logger LOG = LoggerFactory.getLogger(SolarFlux.class);
    public static final SFRCommonProxy PROXY = (SFRCommonProxy)IProxy.create(() -> SFRClientProxy::new, () -> SFRCommonProxy::new);
    @CreativeTab.RegisterTab
    public static final CreativeTab ITEM_GROUP = new CreativeTab(Resources.location((String)"solarflux", (String)"root"), b -> b.icon(() -> ((Item)ItemsSF.PHOTOVOLTAIC_CELL_3).getDefaultInstance()).title((Component)Component.translatable((String)"itemGroup.solarflux")).withTabsBefore(new ResourceLocation[]{HLConstants.HL_TAB.id()}));
    public static SFCompatList SF_COMPAT;

    public SolarFlux(IEventBus modBus) {
        SF_COMPAT = (SFCompatList)CompatList.gather(SolarFluxCompat.class, (CompatContext)CompatContext.builder((IEventBus)modBus).build(), SFCompatList::new);
        NeoForge.EVENT_BUS.register((Object)this);
        modBus.addListener(RecipesSF::addRecipes);
        SolarPanelsSF.init();
        SF_COMPAT.setupSolarPanels();
        LanguageAdapter.registerMod((String)MOD_ID);
        ResourcePackAdapter.registerResourcePack((PackResources)SolarFluxResourcePack.getPackInstance());
        CommonMessages.printMessageOnIllegalRedistribution(SolarFlux.class, (Logger)LOG, (String)"Solar Flux Reborn", (String)"https://www.curseforge.com/minecraft/mc-mods/solar-flux-reborn");
    }

    public static ResourceLocation id(String s) {
        return Resources.location((String)MOD_ID, (String)s);
    }

    @SubscribeEvent
    public void startServer(RegisterCommandsEvent e) {
        e.getDispatcher().register((LiteralArgumentBuilder)Commands.literal((String)MOD_ID).then(Commands.literal((String)"reload").executes(src -> {
            SolarPanelsSF.refreshConfigs();
            ((CommandSourceStack)src.getSource()).getServer().getPlayerList().getPlayers().forEach(PacketSyncPanelData::sendAllPanels);
            return 1;
        })));
    }

    @SubscribeEvent
    public void playerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        Player player = e.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            LOG.info("Sending solar panels to {}.", (Object)sp.getGameProfile().getName());
            PacketSyncPanelData.sendAllPanels(sp);
        }
    }

    @EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
    public static class ModEvents {
        @SubscribeEvent
        public static void commonSetup(FMLCommonSetupEvent e) {
            PROXY.commonSetup();
            SolarFluxResourcePack.canInit = true;
        }

        @SubscribeEvent
        public static void loadComplete(FMLLoadCompleteEvent e) {
            SolarPanelsSF.refreshConfigs();
        }

        @SubscribeEvent
        public static void fingerprintCheck(FMLFingerprintCheckEvent e) {
            CommonMessages.printMessageOnFingerprintViolation((FMLFingerprintCheckEvent)e, (String)"97e852e9b3f01b83574e8315f7e77651c6605f2b455919a7319e9869564f013c", (Logger)LOG, (String)"Solar Flux Reborn", (String)"https://www.curseforge.com/minecraft/mc-mods/solar-flux-reborn");
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public static void modelBake(ModelEvent.ModifyBakingResult e) {
            SolarPanelsSF.listPanels().forEach(spb -> e.getModels().put(new ModelResourceLocation(spb.getRegistryName(), ""), new SolarPanelBakedModel(spb.getBlock())));
        }
    }
}

