/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.mcf;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.AbstractList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public class BlockPosList
extends AbstractList<BlockPos>
implements INBTSerializable<ListTag> {
    final LongList backing;

    public BlockPosList() {
        this.backing = new LongArrayList();
    }

    public BlockPosList(int capacity) {
        this.backing = new LongArrayList(capacity);
    }

    public BlockPosList(ListTag lst) {
        this.backing = new LongArrayList(lst.size());
        this.deserializeNBT(null, lst);
    }

    @Override
    public void clear() {
        this.backing.clear();
    }

    @Override
    public void add(int index, BlockPos element) {
        this.backing.add(index, element.asLong());
    }

    @Override
    public BlockPos remove(int index) {
        return BlockPos.of((long)this.backing.removeLong(index));
    }

    @Override
    public int indexOf(Object o) {
        return o instanceof BlockPos ? this.backing.indexOf(((BlockPos)o).asLong()) : -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        return o instanceof BlockPos ? this.backing.lastIndexOf(((BlockPos)o).asLong()) : -1;
    }

    @Override
    public BlockPos get(int index) {
        return BlockPos.of((long)this.backing.getLong(index));
    }

    @Override
    public BlockPos set(int index, BlockPos element) {
        return BlockPos.of((long)this.backing.set(index, element.asLong()));
    }

    @Override
    public int size() {
        return this.backing.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backing.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return o instanceof BlockPos && this.backing.contains(((BlockPos)o).asLong());
    }

    @Override
    public boolean add(BlockPos blockPos) {
        return this.backing.add(blockPos.asLong());
    }

    @Override
    public boolean remove(Object o) {
        return o instanceof BlockPos && this.backing.remove((Object)((BlockPos)o).asLong());
    }

    public @UnknownNullability ListTag serializeNBT(HolderLookup.Provider provider) {
        ListTag nbt = new ListTag();
        this.backing.forEach(l -> nbt.add((Object)LongTag.valueOf((long)l)));
        return nbt;
    }

    public void deserializeNBT(@Nullable HolderLookup.Provider provider, ListTag nbt) {
        this.backing.clear();
        nbt.forEach(i -> this.backing.add(((LongTag)i).getAsLong()));
    }
}

