/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.zeith.hammerlib.net.PacketContext;
import org.zeith.hammerlib.util.java.Threading;

public interface IPacket {
    default public void write(FriendlyByteBuf buf) {
    }

    default public void read(FriendlyByteBuf buf) {
    }

    default public void write(RegistryFriendlyByteBuf buf) {
        this.write((FriendlyByteBuf)buf);
    }

    default public void read(RegistryFriendlyByteBuf buf) {
        this.read((FriendlyByteBuf)buf);
    }

    default public void execute(PacketContext ctx) {
        switch (ctx.getSide()) {
            case CLIENT: {
                this.clientExecute(ctx);
                return;
            }
        }
        this.serverExecute(ctx);
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void clientExecute(PacketContext ctx) {
    }

    default public void serverExecute(PacketContext ctx) {
    }

    default public boolean executeOnMainThread() {
        return Threading.isMainThreaded(this.getClass());
    }
}

