/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.model.builtin;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.BakedModelWrapper;
import net.neoforged.neoforge.client.model.IQuadTransformer;
import net.neoforged.neoforge.client.model.QuadTransformers;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.client.model.IUnbakedGeometry;
import org.zeith.hammerlib.client.model.LoadUnbakedGeometry;

@LoadUnbakedGeometry(path="emissive")
public class EmissiveGeometry
implements IUnbakedGeometry<EmissiveGeometry> {
    protected ResourceLocation parentLocation;
    protected UnbakedModel parent;
    protected int emissivity;

    public EmissiveGeometry(JsonObject obj, JsonDeserializationContext context) {
        if (obj.has("inline_parent") && obj.get("inline_parent").isJsonObject()) {
            this.parent = (UnbakedModel)context.deserialize((JsonElement)obj.getAsJsonObject("inline_parent"), BlockModel.class);
        } else {
            this.parentLocation = ResourceLocation.tryParse((String)GsonHelper.getAsString((JsonObject)obj, (String)"parent"));
        }
        this.emissivity = GsonHelper.getAsInt((JsonObject)obj, (String)"emissivity", (int)15);
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides) {
        BakedModel res = this.parent != null && this.parentLocation == null ? baker.bakeUncached(this.parent, modelState, spriteGetter) : baker.bake(this.parentLocation, modelState, spriteGetter);
        return res == null ? null : new EmissiveQuadApplierModel(res, QuadTransformers.settingEmissivity((int)this.emissivity));
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
        if (this.parentLocation != null) {
            this.parent = modelGetter.apply(this.parentLocation);
        }
        if (this.parent != null) {
            this.parent.resolveParents(modelGetter);
        }
    }

    public static class EmissiveQuadApplierModel
    extends BakedModelWrapper<BakedModel> {
        protected final IQuadTransformer transformer;

        public EmissiveQuadApplierModel(BakedModel originalModel, IQuadTransformer transformer) {
            super(originalModel);
            this.transformer = transformer;
        }

        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
            return this.transformer.process(super.getQuads(state, side, rand));
        }

        @NotNull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
            return this.transformer.process(super.getQuads(state, side, rand, extraData, renderType));
        }

        public BakedModel applyTransform(ItemDisplayContext cameraTransformType, PoseStack poseStack, boolean applyLeftHandTransform) {
            BakedModel bm = super.applyTransform(cameraTransformType, poseStack, applyLeftHandTransform);
            if (bm == this.originalModel) {
                return this;
            }
            return new EmissiveQuadApplierModel(bm, this.transformer);
        }

        public List<BakedModel> getRenderPasses(ItemStack itemStack, boolean fabulous) {
            return List.of(this);
        }
    }
}

