/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.flowgui.objects;

import com.mojang.blaze3d.systems.RenderSystem;
import lombok.Generated;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.zeith.hammerlib.client.flowgui.Graphics;
import org.zeith.hammerlib.client.flowgui.GuiObject;
import org.zeith.hammerlib.client.flowgui.MousePos;
import org.zeith.hammerlib.util.math.Point;

public class GuiButtonObject
extends GuiObject {
    public static final int UNSET_FG_COLOR = -1;
    public float alpha;
    protected int packedFGColor;
    public boolean enabled;
    public Component message;
    public OnPress callback;
    protected static final WidgetSprites SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"widget/button"), ResourceLocation.withDefaultNamespace((String)"widget/button_disabled"), ResourceLocation.withDefaultNamespace((String)"widget/button_highlighted"));

    public GuiButtonObject(@NotNull String name, float alpha, int packedFGColor, boolean enabled, @NotNull Component message, @NotNull OnPress callback) {
        super(name);
        this.alpha = alpha;
        this.packedFGColor = packedFGColor;
        this.enabled = enabled;
        this.message = message;
        this.callback = callback;
    }

    public GuiButtonObject setAlpha(float alpha) {
        this.alpha = alpha;
        return this;
    }

    public GuiButtonObject setPackedFGColor(int packedFGColor) {
        this.packedFGColor = packedFGColor;
        return this;
    }

    @Override
    public GuiButtonObject setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public GuiButtonObject setMessage(Component message) {
        this.message = message;
        return this;
    }

    public static GuiButtonObjectBuilder builder(String name) {
        return new GuiButtonObjectBuilder().name(name).alpha(1.0f).packedFGColor(-1).enabled(true).message((Component)Component.empty()).callback(OnPress.NONE);
    }

    @Override
    protected void render(Graphics gfx, MousePos pos) {
        Minecraft minecraft = Minecraft.getInstance();
        GuiGraphics pGuiGraphics = gfx.gfx();
        pGuiGraphics.setColor(1.0f, 1.0f, 1.0f, this.alpha);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        pGuiGraphics.blitSprite(SPRITES.get(this.enabled, pos.isMouseWithin(this)), 0, 0, (int)this.width, (int)this.height);
        pGuiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        int i = this.getFGColor();
        this.renderString(pGuiGraphics, minecraft.font, i | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
    }

    public void onPress() {
        this.callback.onPress(this);
        this.playDownSound(Minecraft.getInstance().getSoundManager());
    }

    @Override
    protected boolean onMouseClicked(Point globalMousePos, MousePos pos, int button) {
        if (button == 0 && this.enabled && pos.isMouseWithin(this)) {
            this.onPress();
            return true;
        }
        return false;
    }

    public void playDownSound(SoundManager pHandler) {
        pHandler.play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
    }

    private int getTextureY(boolean hovered) {
        int i = 1;
        if (!this.enabled) {
            i = 0;
        } else if (hovered) {
            i = 2;
        }
        return 46 + i * 20;
    }

    public int getFGColor() {
        if (this.packedFGColor != -1) {
            return this.packedFGColor;
        }
        return this.enabled ? 0xFFFFFF : 0xA0A0A0;
    }

    public void renderString(GuiGraphics pGuiGraphics, Font pFont, int pColor) {
        this.renderScrollingString(pGuiGraphics, pFont, 2, pColor);
    }

    protected void renderScrollingString(GuiGraphics pGuiGraphics, Font pFont, int pWidth, int pColor) {
        int i = pWidth;
        int j = (int)(this.width - (float)pWidth);
        GuiButtonObject.renderScrollingString(pGuiGraphics, pFont, this.message, i, 0, j, (int)this.height, pColor);
    }

    protected static void renderScrollingString(GuiGraphics pGuiGraphics, Font pFont, Component pText, int pMinX, int pMinY, int pMaxX, int pMaxY, int pColor) {
        int i = pFont.width((FormattedText)pText);
        int j = (pMinY + pMaxY - 9) / 2 + 1;
        int k = pMaxX - pMinX;
        if (i > k) {
            int l = i - k;
            double d0 = (double)Util.getMillis() / 1000.0;
            double d1 = Math.max((double)l * 0.5, 3.0);
            double d2 = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d0 / d1)) / 2.0 + 0.5;
            double d3 = Mth.lerp((double)d2, (double)0.0, (double)l);
            pGuiGraphics.enableScissor(pMinX, pMinY, pMaxX, pMaxY);
            pGuiGraphics.drawString(pFont, pText, pMinX - (int)d3, j, pColor);
            pGuiGraphics.disableScissor();
        } else {
            pGuiGraphics.drawCenteredString(pFont, pText, (pMinX + pMaxX) / 2, j, pColor);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface OnPress {
        public static final OnPress NONE = b -> {};

        public void onPress(GuiButtonObject var1);
    }

    public static class GuiButtonObjectBuilder {
        @Generated
        private String name;
        @Generated
        private float alpha;
        @Generated
        private int packedFGColor;
        @Generated
        private boolean enabled;
        @Generated
        private Component message;
        @Generated
        private OnPress callback;

        private GuiButtonObjectBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        GuiButtonObjectBuilder() {
        }

        @Generated
        public GuiButtonObjectBuilder alpha(float alpha) {
            this.alpha = alpha;
            return this;
        }

        @Generated
        public GuiButtonObjectBuilder packedFGColor(int packedFGColor) {
            this.packedFGColor = packedFGColor;
            return this;
        }

        @Generated
        public GuiButtonObjectBuilder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Generated
        public GuiButtonObjectBuilder message(@NotNull Component message) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.message = message;
            return this;
        }

        @Generated
        public GuiButtonObjectBuilder callback(@NotNull OnPress callback) {
            if (callback == null) {
                throw new NullPointerException("callback is marked non-null but is null");
            }
            this.callback = callback;
            return this;
        }

        @Generated
        public GuiButtonObject build() {
            return new GuiButtonObject(this.name, this.alpha, this.packedFGColor, this.enabled, this.message, this.callback);
        }

        @Generated
        public String toString() {
            return "GuiButtonObject.GuiButtonObjectBuilder(name=" + this.name + ", alpha=" + this.alpha + ", packedFGColor=" + this.packedFGColor + ", enabled=" + this.enabled + ", message=" + String.valueOf(this.message) + ", callback=" + String.valueOf(this.callback) + ")";
        }
    }
}

