/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.adapter;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import org.zeith.hammerlib.api.fml.IRegisterListener;
import org.zeith.hammerlib.util.mcf.Resources;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class ResourcePackAdapter {
    public static final List<PackResources> BUILTIN_PACKS = new ArrayList<PackResources>();

    public static void registerResourcePack(PackResources pack) {
        if (!BUILTIN_PACKS.contains(pack)) {
            BUILTIN_PACKS.add(pack);
        }
    }

    @SubscribeEvent
    public static void addPacks(AddPackFindersEvent e) {
        e.addRepositorySource(add -> {
            for (final PackResources pack : BUILTIN_PACKS) {
                IRegisterListener rl;
                if (pack instanceof IRegisterListener) {
                    rl = (IRegisterListener)pack;
                    rl.onPreRegistered(Resources.locationOrNull(pack.packId()));
                }
                add.accept(Pack.readMetaAndCreate((PackLocationInfo)new PackLocationInfo(pack.packId(), (Component)Component.literal((String)pack.packId()), PackSource.BUILT_IN, Optional.empty()), (Pack.ResourcesSupplier)new Pack.ResourcesSupplier(){

                    public PackResources openPrimary(PackLocationInfo info) {
                        return pack;
                    }

                    public PackResources openFull(PackLocationInfo info, Pack.Metadata meta) {
                        return pack;
                    }
                }, (PackType)PackType.CLIENT_RESOURCES, (PackSelectionConfig)new PackSelectionConfig(true, Pack.Position.TOP, true)));
                if (!(pack instanceof IRegisterListener)) continue;
                rl = (IRegisterListener)pack;
                rl.onPostRegistered(Resources.locationOrNull(pack.packId()));
            }
        });
    }
}

