/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.io.serializers;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.api.io.NBTSerializer;
import org.zeith.hammerlib.api.io.serializers.INBTSerializer;

@NBTSerializer(value={ResourceKey.class})
public class ResourceKeySerializer
implements INBTSerializer<ResourceKey> {
    @Override
    public void serialize(HolderLookup.Provider provider, String key, @NotNull ResourceKey value, CompoundTag nbt) {
        if (value != null) {
            CompoundTag tag = new CompoundTag();
            tag.putString("Registry", value.registry().toString());
            tag.putString("Location", value.location().toString());
            nbt.put(key, (Tag)tag);
        }
    }

    @Override
    @Nullable
    public ResourceKey deserialize(HolderLookup.Provider provider, String key, CompoundTag nbt) {
        if (!nbt.contains(key, 10)) {
            return null;
        }
        CompoundTag tag = nbt.getCompound(key);
        ResourceLocation reg = ResourceLocation.tryParse((String)tag.getString("Registry"));
        ResourceLocation loc = ResourceLocation.tryParse((String)tag.getString("Location"));
        return reg != null && loc != null ? ResourceKey.create((ResourceKey)ResourceKey.createRegistryKey((ResourceLocation)reg), (ResourceLocation)loc) : null;
    }
}

