/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.energy;

import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class ForgeEnergyHelper {
    public static int suckPower(Level level, BlockPos into, int lim, boolean simulate) {
        AtomicInteger sucked = new AtomicInteger();
        for (Direction dir : Direction.values()) {
            int e;
            IEnergyStorage extractor;
            IEnergyStorage acceptor = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, into, (Object)dir);
            if (acceptor == null || !acceptor.canReceive() || (extractor = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, into.relative(dir), (Object)dir.getOpposite())) == null || !extractor.canExtract() || (e = Math.min(extractor.getEnergyStored(), lim - sucked.get())) <= 0) continue;
            e = acceptor.receiveEnergy(e, true);
            sucked.addAndGet(acceptor.receiveEnergy(extractor.extractEnergy(e, simulate), simulate));
        }
        return sucked.get();
    }

    public static void suckPowerNoTrack(Level level, BlockPos into, int lim, boolean simulate) {
        for (Direction dir : Direction.values()) {
            int e;
            IEnergyStorage extractor;
            IEnergyStorage acceptor = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, into, (Object)dir);
            if (acceptor == null || !acceptor.canReceive() || (extractor = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, into.relative(dir), (Object)dir.getOpposite())) == null || !extractor.canExtract() || (e = Math.min(extractor.getEnergyStored(), lim)) <= 0) continue;
            e = acceptor.receiveEnergy(e, true);
            acceptor.receiveEnergy(extractor.extractEnergy(e, simulate), simulate);
        }
    }

    public static int spreadPower(Level level, BlockPos from, int lim, boolean simulate) {
        AtomicInteger sucked = new AtomicInteger();
        for (Direction dir : Direction.values()) {
            int e;
            IEnergyStorage acceptor;
            IEnergyStorage extractor = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, from, (Object)dir);
            if (extractor == null || !extractor.canExtract() || (acceptor = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, from.relative(dir), (Object)dir.getOpposite())) == null || !acceptor.canReceive() || (e = Math.min(extractor.getEnergyStored(), lim - sucked.get())) <= 0) continue;
            e = acceptor.receiveEnergy(e, true);
            sucked.addAndGet(acceptor.receiveEnergy(extractor.extractEnergy(e, simulate), simulate));
        }
        return sucked.get();
    }

    public static void spreadPowerNoTrack(Level level, BlockPos from, int lim, boolean simulate) {
        for (Direction dir : Direction.values()) {
            int e;
            IEnergyStorage acceptor;
            IEnergyStorage extractor = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, from, (Object)dir);
            if (extractor == null || !extractor.canExtract() || (acceptor = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, from.relative(dir), (Object)dir.getOpposite())) == null || !acceptor.canReceive() || (e = Math.min(extractor.getEnergyStored(), lim)) <= 0) continue;
            e = acceptor.receiveEnergy(e, true);
            acceptor.receiveEnergy(extractor.extractEnergy(e, simulate), simulate);
        }
    }
}

