/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.configured.data;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.function.Predicate;
import org.zeith.hammerlib.util.configured.struct.RangeDouble;
import org.zeith.hammerlib.util.configured.struct.RangeFloat;

public class DecimalValueRange
implements Predicate<Number> {
    private static final BigDecimal MIN_FLOAT_SHIFT = BigDecimal.valueOf(1.4E-45f);
    protected final BigDecimal min;
    protected final BigDecimal max;
    protected final boolean minInclusive;
    protected final boolean maxInclusive;
    protected final boolean eq;

    public DecimalValueRange(BigDecimal min, BigDecimal max, boolean minInclusive, boolean maxInclusive) {
        this.min = min;
        this.max = max;
        this.minInclusive = minInclusive;
        this.maxInclusive = maxInclusive;
        if (max != null && max.compareTo(min) < 0) {
            throw new IllegalArgumentException("The min value of a range is greater than max value. Why?");
        }
        boolean e = max != null && max.compareTo(min) == 0;
        boolean bl = this.eq = e && (minInclusive || maxInclusive);
        if (e && !this.test(min)) {
            throw new IllegalArgumentException("The min value of a range is equal to max value, but is not included. Why?");
        }
    }

    public static DecimalValueRange rangeClosed(BigDecimal minInclusive, BigDecimal maxInclusive) {
        return new DecimalValueRange(minInclusive, maxInclusive, true, true);
    }

    public static DecimalValueRange range(BigDecimal minInclusive, BigDecimal maxExclusive) {
        return new DecimalValueRange(minInclusive, maxExclusive, true, false);
    }

    public static DecimalValueRange min(BigDecimal minExclusive) {
        return new DecimalValueRange(minExclusive, null, false, false);
    }

    public static DecimalValueRange minClosed(BigDecimal minInclusive) {
        return new DecimalValueRange(minInclusive, null, true, false);
    }

    public static DecimalValueRange max(BigDecimal maxExclusive) {
        return new DecimalValueRange(null, maxExclusive, false, false);
    }

    public static DecimalValueRange maxClosed(BigDecimal maxInclusive) {
        return new DecimalValueRange(null, maxInclusive, false, true);
    }

    public static DecimalValueRange rangeClosed(double minInclusive, double maxInclusive) {
        return DecimalValueRange.rangeClosed(BigDecimal.valueOf(minInclusive), BigDecimal.valueOf(maxInclusive));
    }

    public static DecimalValueRange range(double minInclusive, double maxExclusive) {
        return DecimalValueRange.range(BigDecimal.valueOf(minInclusive), BigDecimal.valueOf(maxExclusive));
    }

    public static DecimalValueRange min(double minExclusive) {
        return DecimalValueRange.min(BigDecimal.valueOf(minExclusive));
    }

    public static DecimalValueRange minClosed(double minInclusive) {
        return DecimalValueRange.minClosed(BigDecimal.valueOf(minInclusive));
    }

    public static DecimalValueRange max(double maxExclusive) {
        return DecimalValueRange.max(BigDecimal.valueOf(maxExclusive));
    }

    public static DecimalValueRange maxClosed(double maxInclusive) {
        return DecimalValueRange.maxClosed(BigDecimal.valueOf(maxInclusive));
    }

    public static DecimalValueRange fromFloatRange(RangeFloat r) {
        if (r.min() == Float.MIN_VALUE) {
            return DecimalValueRange.maxClosed(r.max());
        }
        if (r.max() == Float.MAX_VALUE) {
            return DecimalValueRange.minClosed(r.min());
        }
        return DecimalValueRange.rangeClosed(r.min(), r.max());
    }

    public static DecimalValueRange fromDoubleRange(RangeDouble r) {
        if (r.min() == Double.MIN_VALUE) {
            return DecimalValueRange.maxClosed(r.max());
        }
        if (r.max() == Double.MAX_VALUE) {
            return DecimalValueRange.minClosed(r.min());
        }
        return DecimalValueRange.rangeClosed(r.min(), r.max());
    }

    public BigDecimal enclose(BigDecimal origin) {
        if (origin == null) {
            return null;
        }
        if (this.min != null) {
            origin = origin.max(this.minInclusive ? this.min : this.min.add(MIN_FLOAT_SHIFT));
        }
        if (this.max != null) {
            origin = origin.min(this.maxInclusive ? this.max : this.max.subtract(MIN_FLOAT_SHIFT));
        }
        return origin;
    }

    @Override
    public boolean test(Number number) {
        BigDecimal big;
        if (number instanceof BigDecimal) {
            BigDecimal bdec;
            big = bdec = (BigDecimal)number;
        } else if (number instanceof BigInteger) {
            BigInteger bint = (BigInteger)number;
            big = new BigDecimal(bint);
        } else {
            big = BigDecimal.valueOf(number.longValue());
        }
        if (this.eq && big.equals(this.min)) {
            return true;
        }
        if (this.min != null && big.compareTo(this.min) < (this.minInclusive ? 0 : 1)) {
            return false;
        }
        return this.max == null || big.compareTo(this.max) <= (this.maxInclusive ? 0 : 1);
    }

    public String toString() {
        return (this.minInclusive && this.min != null ? "[" : "(") + String.valueOf(this.min != null ? this.min : "-") + "; " + String.valueOf(this.max != null ? this.max : "+") + (this.maxInclusive && this.max != null ? "]" : ")");
    }
}

