/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util;

import java.net.URL;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.fml.loading.FMLEnvironment;
import org.slf4j.Logger;
import org.zeith.hammerlib.client.adapter.ChatMessageAdapter;
import org.zeith.hammerlib.core.adapter.ModSourceAdapter;
import org.zeith.hammerlib.event.fml.FMLFingerprintCheckEvent;

public class CommonMessages {
    public static final Component CRAFTING_MATERIAL = Component.translatable((String)"info.hammerlib.material").withStyle(ChatFormatting.GRAY);

    public static CheckResult printMessageOnIllegalRedistribution(Class<?> modClass, org.apache.logging.log4j.Logger log, String modName, String downloadUrl) {
        return CommonMessages.printMessageOnIllegalRedistribution(modClass, AbstractLogger.ofLog4j(log), modName, downloadUrl);
    }

    public static CheckResult printMessageOnIllegalRedistribution(Class<?> modClass, Logger log, String modName, String downloadUrl) {
        return CommonMessages.printMessageOnIllegalRedistribution(modClass, AbstractLogger.ofSlf4j(log), modName, downloadUrl);
    }

    public static CheckResult printMessageOnFingerprintViolation(FMLFingerprintCheckEvent event, String expectFingerprint, org.apache.logging.log4j.Logger log, String modName, String downloadUrl) {
        return CommonMessages.printMessageOnFingerprintViolation(event, expectFingerprint, AbstractLogger.ofLog4j(log), modName, downloadUrl);
    }

    public static CheckResult printMessageOnFingerprintViolation(FMLFingerprintCheckEvent event, String expectFingerprint, Logger log, String modName, String downloadUrl) {
        return CommonMessages.printMessageOnFingerprintViolation(event, expectFingerprint, AbstractLogger.ofSlf4j(log), modName, downloadUrl);
    }

    public static CheckResult printMessageOnIllegalRedistribution(Class<?> modClass, AbstractLogger log, String modName, String downloadUrl) {
        if (!FMLEnvironment.production) {
            return CheckResult.DEV_ENV;
        }
        ModSourceAdapter.ModSource illegalSourceNotice = ModSourceAdapter.getModSource(modClass).filter(ModSourceAdapter.ModSource::wasDownloadedIllegally).orElse(null);
        if (illegalSourceNotice != null) {
            log.error("=".repeat(52), new Object[0]);
            log.error("== WARNING: " + modName + " was downloaded from " + illegalSourceNotice.referrerDomain() + ", which has been marked as illegal site over at stopmodreposts.org.", new Object[0]);
            log.error("== Please download the mod from " + downloadUrl, new Object[0]);
            log.error("=".repeat(52), new Object[0]);
            MutableComponent illegalUri = Component.literal((String)illegalSourceNotice.referrerDomain()).withStyle(s -> s.withColor(ChatFormatting.RED));
            MutableComponent smrUri = Component.literal((String)"stopmodreposts.org").withStyle(s -> s.withColor(ChatFormatting.BLUE).withUnderlined(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://stopmodreposts.org/")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to open webpage."))));
            String host = downloadUrl;
            try {
                host = new URL(downloadUrl).getAuthority();
            }
            catch (Exception exception) {
                // empty catch block
            }
            MutableComponent curseforgeUri = Component.literal((String)host).withStyle(s -> s.withColor(ChatFormatting.BLUE).withUnderlined(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, downloadUrl)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to open webpage."))));
            ChatMessageAdapter.sendOnFirstWorldLoad((Component)Component.literal((String)("WARNING: " + modName + " was downloaded from ")).append((Component)illegalUri).append(", which has been marked as illegal site over at ").append((Component)smrUri).append(". Please download the mod from ").append((Component)curseforgeUri).append("."));
            return CheckResult.VIOLATION_FOUND;
        }
        return CheckResult.OK;
    }

    public static CheckResult printMessageOnFingerprintViolation(FMLFingerprintCheckEvent event, String expectFingerprint, AbstractLogger log, String modName, String downloadUrl) {
        if (!FMLEnvironment.production) {
            return CheckResult.DEV_ENV;
        }
        String modFile = event.getModContainer().getModInfo().getOwningFile().getFile().getFileName();
        String trustData = event.trustData().map(s -> "Trust[" + s + "]").orElse("[No Trust Data]");
        if (!event.isViolated(expectFingerprint)) {
            log.info("{} ({}) has passed the jar integrity check. {}", modName, modFile, trustData);
            return CheckResult.OK;
        }
        log.error("=".repeat(52), new Object[0]);
        log.error("== WARNING: Somebody has been tampering with " + modName + "'s jar! (" + modFile + ")", new Object[0]);
        log.error("== It is highly recommended that you re-download it from " + downloadUrl, new Object[0]);
        log.error("== Expected fingerprint {}, but got {}. {}", expectFingerprint, event.fingerprint().map(s -> s.replace(":", "")).orElse(null), trustData);
        Set<String> set = event.getInvalidSignedFiles();
        if (!set.isEmpty()) {
            log.error("== Here are " + set.size() + " files that have been found to be corrupted:", new Object[0]);
            for (String e : set) {
                log.error("== " + e, new Object[0]);
            }
        }
        log.error("=".repeat(52), new Object[0]);
        String host = downloadUrl;
        try {
            host = new URL(downloadUrl).getAuthority();
        }
        catch (Exception e) {
            // empty catch block
        }
        MutableComponent curseforgeUri = Component.literal((String)host).withStyle(s -> s.withColor(ChatFormatting.BLUE).withUnderlined(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, downloadUrl)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to open webpage."))));
        ChatMessageAdapter.sendOnFirstWorldLoad((Component)Component.literal((String)("WARNING: " + modName + " was tampered by someone. Please download the mod from ")).append((Component)curseforgeUri).append("."));
        return CheckResult.VIOLATION_FOUND;
    }

    static interface AbstractLogger {
        public void info(String var1, Object ... var2);

        public void error(String var1, Object ... var2);

        public static AbstractLogger ofSlf4j(final Logger log) {
            return new AbstractLogger(){

                @Override
                public void info(String text, Object ... args) {
                    log.info(text, args);
                }

                @Override
                public void error(String text, Object ... args) {
                    log.error(text, args);
                }
            };
        }

        public static AbstractLogger ofLog4j(final org.apache.logging.log4j.Logger log) {
            return new AbstractLogger(){

                @Override
                public void info(String text, Object ... args) {
                    log.info(text, args);
                }

                @Override
                public void error(String text, Object ... args) {
                    log.error(text, args);
                }
            };
        }
    }

    public static enum CheckResult {
        OK,
        DEV_ENV,
        VIOLATION_FOUND;

    }
}

