/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.tiles.tooltip.own.impl;

import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.zeith.hammerlib.tiles.tooltip.EnumTooltipEngine;
import org.zeith.hammerlib.tiles.tooltip.ITooltipTile;
import org.zeith.hammerlib.tiles.tooltip.own.ITooltipProvider;
import org.zeith.hammerlib.tiles.tooltip.own.impl.GuiTooltip;
import org.zeith.hammerlib.tiles.tooltip.own.impl.WrappedTooltipEngine;

@OnlyIn(value=Dist.CLIENT)
public class TooltipRenderEngine
implements LayeredDraw.Layer {
    public HitResult.Type lastType;
    public BlockPos lastPos;
    public UUID lastEntity;
    public GuiTooltip lastTooltip;

    public void render(GuiGraphics gfx, DeltaTracker partialTick) {
        Minecraft mc = Minecraft.getInstance();
        HitResult res = mc.hitResult;
        if (res != null) {
            EntityHitResult ehr;
            ClientLevel wc;
            if (res.getType() == HitResult.Type.BLOCK && res instanceof BlockHitResult) {
                boolean diffPos;
                ITooltipTile t;
                BlockHitResult bhr = (BlockHitResult)res;
                wc = mc.level;
                BlockPos bp = bhr.getBlockPos();
                Block bl = wc.getBlockState(bp).getBlock();
                BlockEntity tl = wc.getBlockEntity(bp);
                ITooltipProvider prov = null;
                if (tl instanceof ITooltipProvider) {
                    ITooltipProvider t2;
                    prov = t2 = (ITooltipProvider)tl;
                } else if (bl instanceof ITooltipProvider) {
                    ITooltipProvider t3;
                    prov = t3 = (ITooltipProvider)bl;
                } else if (tl instanceof ITooltipTile && (t = (ITooltipTile)tl).isEngineSupported(EnumTooltipEngine.HAMMER_LIB)) {
                    prov = new WrappedTooltipEngine(tl, t);
                }
                boolean bl2 = diffPos = !Objects.equals(bp, this.lastPos);
                if (diffPos) {
                    this.lastPos = bp;
                    this.lastTooltip = null;
                }
                if (prov != null && (this.lastType != res.getType() || diffPos || this.lastTooltip == null || this.lastTooltip.isDirty())) {
                    prov.setTooltipDirty(false);
                    this.lastTooltip = new GuiTooltip().withPlayer((Player)mc.player).withLocation((Level)wc, bp).withBlockHitResult(bhr).withProvider(prov);
                }
                this.lastType = res.getType();
            } else if (res.getType() == HitResult.Type.ENTITY && res instanceof EntityHitResult && (wc = (ehr = (EntityHitResult)res).getEntity()) instanceof ITooltipProvider) {
                boolean diffEntity;
                ITooltipProvider prov = (ITooltipProvider)wc;
                Entity ent = ehr.getEntity();
                boolean bl = diffEntity = !Objects.equals(ent.getUUID(), this.lastEntity);
                if (diffEntity) {
                    this.lastEntity = ent.getUUID();
                    this.lastTooltip = null;
                }
                if (diffEntity && (this.lastType != res.getType() || prov.isTooltipDirty() || this.lastTooltip == null || this.lastTooltip.isDirty())) {
                    prov.setTooltipDirty(false);
                    this.lastTooltip = new GuiTooltip().withPlayer((Player)mc.player).withEntity(ent).withProvider(prov);
                }
                this.lastType = res.getType();
            } else {
                this.lastPos = null;
                this.lastTooltip = null;
            }
        } else {
            this.lastPos = null;
            this.lastTooltip = null;
        }
        if (this.lastTooltip != null) {
            int sw = gfx.guiWidth();
            int sh = gfx.guiHeight();
            float cx = (float)sw / 2.0f + 12.0f;
            float cy = ((float)sh - this.lastTooltip.getHeight()) / 2.0f + 2.0f;
            this.lastTooltip.render(gfx, cx, cy, partialTick);
        }
    }
}

