/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net.packets;

import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.AdvancementToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.MainThreaded;
import org.zeith.hammerlib.net.PacketContext;

@MainThreaded
public class PacketAdvancementToast
implements IPacket {
    private ResourceLocation advancement;

    public PacketAdvancementToast(ResourceLocation advancement) {
        this.advancement = advancement;
    }

    public PacketAdvancementToast() {
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeResourceLocation(this.advancement);
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.advancement = buf.readResourceLocation();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientExecute(PacketContext ctx) {
        Minecraft mc = Minecraft.getInstance();
        ClientPacketListener connection = mc.getConnection();
        if (connection == null) {
            return;
        }
        AdvancementHolder adv = connection.getAdvancements().get(this.advancement);
        if (adv == null) {
            return;
        }
        mc.getToasts().addToast((Toast)new AdvancementToast(adv));
    }
}

