/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net;

import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.net.HLTargetPoint;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.PlainHLMessage;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.mcf.LogicalSidePredictor;
import org.zeith.hammerlib.util.mcf.ModHelper;
import org.zeith.hammerlib.util.mcf.Resources;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class Network {
    public static final CustomPacketPayload.Type<PlainHLMessage> MAIN_CHANNEL = new CustomPacketPayload.Type(Resources.location("hammerlib", "main"));

    @SubscribeEvent
    private static void initialize(RegisterPayloadHandlersEvent event) {
        HammerLib.LOG.info("Setup HammerLib networking!");
        PayloadRegistrar reg = event.registrar("hammerlib").versioned(ModHelper.getModVersion("hammerlib"));
        reg.playBidirectional(MAIN_CHANNEL, StreamCodec.ofMember(PlainHLMessage::write, PlainHLMessage::new), PlainHLMessage::handle);
    }

    public static void sendTo(Player player, IPacket packet) {
        Network.sendTo(packet, player);
    }

    public static void sendTo(ServerPlayer player, IPacket packet) {
        Network.sendTo(packet, player);
    }

    public static void sendTo(IPacket packet, Player player) {
        if (packet != null && player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)Network.toPlain(packet), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void sendTo(IPacket packet, ServerPlayer player) {
        if (player != null && packet != null) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)Network.toPlain(packet), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void sendToTracking(LevelChunk chunk, IPacket packet) {
        Network.sendToTracking(packet, chunk);
    }

    public static void sendToTracking(IPacket packet, LevelChunk chunk) {
        Level level;
        if (packet != null && chunk != null && (level = chunk.getLevel()) instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)sl, (ChunkPos)chunk.getPos(), (CustomPacketPayload)Network.toPlain(packet), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void sendToTracking(BlockEntity tile, IPacket packet) {
        Network.sendToTracking(packet, tile);
    }

    public static void sendToTracking(IPacket packet, BlockEntity tile) {
        if (packet != null && tile != null && tile.hasLevel() && !tile.getLevel().isClientSide) {
            Network.sendToTracking(packet, tile.getLevel().getChunkAt(tile.getBlockPos()));
        }
    }

    public static void sendToTracking(Entity entity, IPacket packet) {
        Network.sendToTracking(packet, entity);
    }

    public static void sendToTracking(IPacket packet, Entity entity) {
        if (packet != null && entity != null) {
            PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)Network.toPlain(packet), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void sendToTrackingAndSelf(Entity entity, IPacket packet) {
        Network.sendToTrackingAndSelf(packet, entity);
    }

    public static void sendToTrackingAndSelf(IPacket packet, Entity entity) {
        if (packet != null && entity != null) {
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)Network.toPlain(packet), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void sendToDimension(Level dim, IPacket packet) {
        ServerLevel sl;
        block5: {
            block4: {
                if (!(dim instanceof ServerLevel)) break block4;
                sl = (ServerLevel)dim;
                if (packet != null) break block5;
            }
            return;
        }
        if (LogicalSidePredictor.getCurrentLogicalSide() == LogicalSide.SERVER) {
            PacketDistributor.sendToPlayersInDimension((ServerLevel)sl, (CustomPacketPayload)Network.toPlain(packet), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void sendToAll(IPacket packet) {
        if (packet == null) {
            return;
        }
        if (LogicalSidePredictor.getCurrentLogicalSide() == LogicalSide.SERVER) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)Network.toPlain(packet), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void sendToArea(HLTargetPoint point, IPacket packet) {
        if (point == null || point.dim == null || packet == null) {
            return;
        }
        Network.sendToArea(point.dim, point.excluded, point, point.range, packet);
    }

    public static void sendToArea(ServerLevel level, @Nullable ServerPlayer excluded, Vec3 pos, double radius, IPacket packet) {
        if (LogicalSidePredictor.getCurrentLogicalSide() == LogicalSide.SERVER) {
            PacketDistributor.sendToPlayersNear((ServerLevel)level, (ServerPlayer)excluded, (double)pos.x, (double)pos.y, (double)pos.z, (double)radius, (CustomPacketPayload)Network.toPlain(packet), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void sendToServer(IPacket packet) {
        if (packet == null) {
            return;
        }
        if (LogicalSidePredictor.getCurrentLogicalSide() == LogicalSide.CLIENT) {
            PacketDistributor.sendToServer((CustomPacketPayload)Network.toPlain(packet), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static PlainHLMessage toPlain(IPacket packet) {
        return new PlainHLMessage(packet);
    }

    public static void swingHand(Player player, InteractionHand hand) {
        ServerPlayer spe = Cast.cast(player, ServerPlayer.class);
        if (spe != null) {
            spe.serverLevel().getChunkSource().broadcastAndSend((Entity)spe, (Packet)new ClientboundAnimatePacket((Entity)player, hand == InteractionHand.MAIN_HAND ? 0 : 3));
        }
    }
}

