/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.mixins;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.zeith.api.level.ISpoofedRecipeManager;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.core.RecipeHelper;
import org.zeith.hammerlib.event.recipe.SpoofRecipesEvent;
import org.zeith.hammerlib.util.java.Cast;

@Mixin(value={RecipeManager.class})
@Implements(value={@Interface(iface=ISpoofedRecipeManager.class, prefix="isrm$")})
public abstract class RecipeManagerMixin
extends SimpleJsonResourceReloadListener
implements ISpoofedRecipeManager {
    @Shadow
    public Map<ResourceLocation, Recipe<?>> byName;
    @Unique
    private final Map<ResourceLocation, List<ResourceLocation>> hammerLib$SpoofByName = SpoofRecipesEvent.gather();

    public RecipeManagerMixin(Gson gson, String dir) {
        super(gson, dir);
    }

    @Inject(method={"byKey"}, at={@At(value="HEAD")}, cancellable=true)
    private void HammerLib_replaceRecipeId(ResourceLocation id, CallbackInfoReturnable<Optional<? extends Recipe<?>>> cir) {
        if (id == null || !this.hammerLib$SpoofByName.containsKey(id)) {
            return;
        }
        Optional recipe = this.findFirstRecipeHL(this.hammerLib$SpoofByName.getOrDefault(id, List.of(id)));
        if (recipe.isPresent()) {
            cir.setReturnValue((Object)recipe);
        } else {
            HammerLib.LOG.error("Failed to locate recipe with mapping " + String.valueOf(id) + "=" + String.valueOf(this.hammerLib$SpoofByName.get(id)));
        }
    }

    @Inject(method={"apply(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/crafting/RecipeManager;makeConditionalOps()Lnet/neoforged/neoforge/common/conditions/ConditionalOps;")})
    public void HammerLib_reloadRecipes(Map<ResourceLocation, JsonElement> recipeMap, ResourceManager p_44038_, ProfilerFiller p_44039_, CallbackInfo ci, @Local ImmutableMultimap.Builder<RecipeType<?>, RecipeHolder<?>> builder, @Local ImmutableMap.Builder<ResourceLocation, RecipeHolder<?>> builder1) {
        RecipeManager mgr = (RecipeManager)Cast.cast(this);
        HashMap addedRecipes = new HashMap();
        HashSet removedRecipes = new HashSet();
        RecipeHelper.injectRecipes(mgr, this.getContext(), id -> recipeMap.containsKey(id) || addedRecipes.containsKey(id), holder -> addedRecipes.put(holder.id(), holder), removedRecipes::add);
        addedRecipes.keySet().removeAll(removedRecipes);
        recipeMap.keySet().removeAll(removedRecipes);
        for (RecipeHolder r : addedRecipes.values()) {
            builder.put((Object)r.value().getType(), (Object)r);
            builder1.put((Object)r.id(), (Object)r);
        }
    }

    public Map<ResourceLocation, List<ResourceLocation>> isrm$getSpoofedRecipesHL() {
        return this.hammerLib$SpoofByName;
    }

    public Optional<? extends Recipe<?>> isrm$findFirstRecipeHL(Collection<ResourceLocation> rl) {
        return rl.stream().map(this.byName::get).filter(Objects::nonNull).findFirst();
    }
}

