/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.event.listeners.client;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import org.zeith.hammerlib.api.blocks.IHitsDifferentTargetBlock;
import org.zeith.hammerlib.mixins.BlockHitResultAccessor;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(value={Dist.CLIENT})
public class InputListener {
    @SubscribeEvent
    public static void mouseClicked(InputEvent.InteractionKeyMappingTriggered event) {
        Minecraft mc = Minecraft.getInstance();
        mc.hitResult = InputListener.alterHitResult(mc.hitResult, (Level)mc.level);
    }

    public static HitResult alterHitResult(HitResult result, Level level) {
        if (result != null && result.getType() == HitResult.Type.BLOCK && result instanceof BlockHitResult) {
            BlockState state;
            Block block;
            BlockHitResult res = (BlockHitResult)result;
            if (level != null && (block = (state = level.getBlockState(res.getBlockPos())).getBlock()) instanceof IHitsDifferentTargetBlock) {
                IHitsDifferentTargetBlock ihdtb = (IHitsDifferentTargetBlock)block;
                BlockPos np = ihdtb.alterHitPosition(level, res.getBlockPos(), state);
                return BlockHitResultAccessor.createBlockHitResult(false, res.getLocation().subtract(Vec3.atLowerCornerOf((Vec3i)res.getBlockPos())).add(Vec3.atLowerCornerOf((Vec3i)np)), res.getDirection(), np, res.isInside());
            }
        }
        return result;
    }
}

