/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.event.fml;

import com.google.common.base.Suppliers;
import cpw.mods.jarhandling.SecureJar;
import cpw.mods.niofs.union.UnionFileSystem;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.event.lifecycle.ModLifecycleEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.moddiscovery.ModFileInfo;

public class FMLFingerprintCheckEvent
extends ModLifecycleEvent {
    private final Optional<String> gotFingerprint;
    private final Optional<String> trustData;
    protected final ModContainer ctr;
    protected final Supplier<Set<String>> filesViolated;

    public FMLFingerprintCheckEvent(ModContainer container) {
        super(container);
        this.ctr = container;
        SecureJar jar = container.getModInfo().getOwningFile().getFile().getSecureJar();
        Path root = ((UnionFileSystem)jar.getRootPath().getFileSystem()).getRoot();
        this.filesViolated = Suppliers.memoize(() -> {
            Set set;
            block9: {
                if (!FMLEnvironment.production) {
                    return Collections.emptySet();
                }
                Stream<Path> walk = Files.walk(root, new FileVisitOption[0]);
                try {
                    set = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(e -> jar.verifyPath(e) == SecureJar.Status.INVALID).map(root::relativize).map(Path::toString).collect(Collectors.toSet());
                    if (walk == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (walk != null) {
                            try {
                                walk.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e2) {
                        throw new UncheckedIOException(e2);
                    }
                }
                walk.close();
            }
            return set;
        });
        ModFileInfo mfi = (ModFileInfo)container.getModInfo().getOwningFile();
        this.gotFingerprint = mfi.getCodeSigningFingerprint();
        Optional trustData = Optional.empty();
        try {
            trustData = mfi.getTrustData();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.trustData = trustData;
    }

    public ModContainer getModContainer() {
        return this.ctr;
    }

    public Optional<String> fingerprint() {
        return this.gotFingerprint;
    }

    public Optional<String> trustData() {
        return this.trustData;
    }

    public Set<String> getInvalidSignedFiles() {
        return this.filesViolated.get();
    }

    public boolean isViolated(String expectFingerprint) {
        expectFingerprint = expectFingerprint.replace(":", "").toLowerCase(Locale.ROOT);
        String gotFingerprint = this.fingerprint().map(f -> f.replace(":", "").toLowerCase(Locale.ROOT)).orElse(null);
        return !Objects.equals(gotFingerprint, expectFingerprint) || !this.getInvalidSignedFiles().isEmpty();
    }
}

