/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.lighting;

import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.zeith.hammerlib.client.utils.IGLBufferStream;
import org.zeith.hammerlib.client.utils.IGLWritable;

public class ColoredLight
implements IGLWritable {
    public static final int FLOAT_SIZE = 8;
    public float x;
    public float y;
    public float z;
    public float r;
    public float g;
    public float b;
    public float a;
    public float radius;

    public ColoredLight(float x, float y, float z, float r, float g, float b, float a, float radius) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        this.radius = radius;
    }

    public ColoredLight reposition(Entity entity, float partialTicks) {
        this.x = (float)(entity.xOld + (entity.getX() - entity.xOld) * (double)partialTicks);
        this.y = (float)(entity.yOld + (entity.getY() - entity.yOld) * (double)partialTicks);
        this.z = (float)(entity.zOld + (entity.getZ() - entity.zOld) * (double)partialTicks);
        return this;
    }

    @Override
    public int getFloatSize() {
        return 8;
    }

    @Override
    public void writeFloats(IGLBufferStream<Float> stream) {
        stream.putAll((Float[])new Float[]{Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), Float.valueOf(this.a)});
        stream.putAll((Float[])new Float[]{Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z)});
        stream.put(Float.valueOf(this.radius));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private float x = Float.NaN;
        private float y = Float.NaN;
        private float z = Float.NaN;
        private float r = Float.NaN;
        private float g = Float.NaN;
        private float b = Float.NaN;
        private float a = Float.NaN;
        private float radius = Float.NaN;

        public Builder pos(Vec3i pos) {
            return this.pos((float)pos.getX() + 0.5f, (float)pos.getY() + 0.5f, (float)pos.getZ() + 0.5f);
        }

        public Builder pos(Vec3 pos) {
            return this.pos(pos.x, pos.y, pos.z);
        }

        public Builder pos(Entity e) {
            return this.pos(e.getX() + (double)(e.getBbWidth() / 2.0f), e.getY() + (double)(e.getBbHeight() / 2.0f), e.getZ() + (double)(e.getBbWidth() / 2.0f));
        }

        public Builder pos(Entity e, float partialTime) {
            return this.pos(e.xOld + (e.getX() - e.xOld) * (double)partialTime + (double)(e.getBbWidth() / 2.0f), e.yOld + (e.getY() - e.yOld) * (double)partialTime + (double)(e.getBbHeight() / 2.0f), e.zOld + (e.getZ() - e.zOld) * (double)partialTime + (double)(e.getBbWidth() / 2.0f));
        }

        public Builder pos(double x, double y, double z) {
            return this.pos((float)x, (float)y, (float)z);
        }

        public Builder pos(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
            return this;
        }

        public Builder color(Vec3 c, float alpha) {
            return this.color((float)c.x, (float)c.y, (float)c.z, alpha);
        }

        public Builder color(Vec3 c) {
            return this.color((float)c.x, (float)c.y, (float)c.z, 1.0f);
        }

        public Builder color(int c, boolean hasAlpha) {
            return this.color(this.extract(c, 2), this.extract(c, 1), this.extract(c, 0), hasAlpha ? this.extract(c, 3) : 1.0f);
        }

        private float extract(int i, int idx) {
            return (float)(i >> idx * 8 & 0xFF) / 255.0f;
        }

        public Builder color(float r, float g, float b) {
            return this.color(r, g, b, 1.0f);
        }

        public Builder color(float r, float g, float b, float a) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
            return this;
        }

        public Builder alpha(int alpha) {
            return this.alpha((float)alpha / 255.0f);
        }

        public Builder alpha(float alpha) {
            this.a = alpha;
            return this;
        }

        public Builder radius(float radius) {
            this.radius = radius;
            return this;
        }

        public ColoredLight build() {
            if (Float.isFinite(this.x) && Float.isFinite(this.y) && Float.isFinite(this.z) && Float.isFinite(this.r) && Float.isFinite(this.g) && Float.isFinite(this.b) && Float.isFinite(this.a) && Float.isFinite(this.radius)) {
                return new ColoredLight(this.x, this.y, this.z, this.r, this.g, this.b, this.a, this.radius);
            }
            throw new IllegalArgumentException("Position, color, and radius must be set, and cannot be infinite");
        }
    }
}

