/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.inv;

import java.util.Iterator;
import java.util.function.BiPredicate;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.UnknownNullability;

public class SimpleInventory
implements IItemHandlerModifiable,
Iterable<ItemStack>,
INBTSerializable<ListTag>,
Container {
    public final NonNullList<ItemStack> items;
    public int stackSizeLimit = 64;
    public ToIntFunction<Integer> getSlotLimit = s -> this.stackSizeLimit;
    public BiPredicate<Integer, ItemStack> isStackValid = (i, s) -> true;

    public SimpleInventory(int slots) {
        this.items = NonNullList.withSize((int)slots, (Object)ItemStack.EMPTY);
    }

    public int getSlots() {
        return this.items.size();
    }

    public ItemStack getStackInSlot(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = this.getStackInSlot(slot);
        if (!stackInSlot.isEmpty()) {
            if (stackInSlot.getCount() >= Math.min(stackInSlot.getMaxStackSize(), this.getSlotLimit(slot))) {
                return stack;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)stackInSlot)) {
                return stack;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            int m = Math.min(stack.getMaxStackSize(), this.getSlotLimit(slot)) - stackInSlot.getCount();
            if (stack.getCount() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.copy();
                    copy.grow(stackInSlot.getCount());
                    this.setStackInSlot(slot, copy);
                }
                return ItemStack.EMPTY;
            }
            stack = stack.copy();
            if (!simulate) {
                ItemStack copy = stack.split(m);
                copy.grow(stackInSlot.getCount());
                this.setStackInSlot(slot, copy);
                return stack;
            }
            stack.shrink(m);
            return stack;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        int m = Math.min(stack.getMaxStackSize(), this.getSlotLimit(slot));
        if (m < stack.getCount()) {
            stack = stack.copy();
            if (!simulate) {
                this.setStackInSlot(slot, stack.split(m));
                return stack;
            }
            stack.shrink(m);
            return stack;
        }
        if (!simulate) {
            this.setStackInSlot(slot, stack);
        }
        return ItemStack.EMPTY;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = this.getStackInSlot(slot);
        if (stackInSlot.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (simulate) {
            if (stackInSlot.getCount() < amount) {
                return stackInSlot.copy();
            }
            ItemStack copy = stackInSlot.copy();
            copy.setCount(amount);
            return copy;
        }
        int m = Math.min(stackInSlot.getCount(), amount);
        ItemStack decrStackSize = this.decrStackSize(slot, m);
        return decrStackSize;
    }

    public ItemStack decrStackSize(int slot, int amount) {
        ItemStack stack = this.getStackInSlot(slot);
        return stack.split(amount);
    }

    public int getSlotLimit(int slot) {
        return this.getSlotLimit.applyAsInt(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.isStackValid.test(slot, stack);
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return this.isItemValid(slot, stack);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (slot >= 0 && slot < this.items.size()) {
            this.items.set(slot, (Object)stack);
        }
    }

    @Override
    public Iterator<ItemStack> iterator() {
        return this.items.iterator();
    }

    public Stream<ItemStack> stream() {
        return this.items.stream();
    }

    public int getContainerSize() {
        return this.getSlots();
    }

    public boolean isEmpty() {
        for (ItemStack e : this) {
            if (e.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        return this.getStackInSlot(slot);
    }

    public ItemStack removeItem(int slot, int count) {
        ItemStack stack = (ItemStack)this.items.get(slot);
        if (!stack.isEmpty()) {
            return stack.split(count);
        }
        return ItemStack.EMPTY;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack itemstack = (ItemStack)this.items.get(slot);
        if (itemstack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.items.set(slot, (Object)ItemStack.EMPTY);
        return itemstack;
    }

    public void setItem(int slot, ItemStack item) {
        this.items.set(slot, (Object)item);
        if (!item.isEmpty() && item.getCount() > this.getMaxStackSize()) {
            item.setCount(this.getMaxStackSize());
        }
        this.setChanged();
    }

    public void setChanged() {
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clearContent() {
        for (int i = 0; i < this.getSlots(); ++i) {
            this.items.set(i, (Object)ItemStack.EMPTY);
        }
    }

    public @UnknownNullability ListTag serializeNBT(HolderLookup.Provider provider) {
        ListTag nbt = new ListTag();
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack stack = (ItemStack)this.items.get(i);
            if (stack.isEmpty()) continue;
            CompoundTag tag = (CompoundTag)stack.save(provider, (Tag)new CompoundTag());
            tag.putInt("Slot", i);
            nbt.add((Object)tag);
        }
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, ListTag nbt) {
        for (int i = 0; i < nbt.size(); ++i) {
            CompoundTag tag = nbt.getCompound(i);
            ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag);
            short slot = tag.getShort("Slot");
            if (slot < 0 || slot >= this.items.size()) continue;
            this.items.set((int)slot, (Object)stack);
        }
    }
}

