/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.inv;

import io.netty.buffer.Unpooled;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import org.zeith.hammerlib.api.inv.ComplexProgressManager;
import org.zeith.hammerlib.net.properties.IProperty;

public interface ComplexProgressHandler {
    public ComplexProgressManager create();

    public void update(ComplexProgressManager var1);

    public void containerTick(ComplexProgressManager var1);

    public static ComplexProgressHandler withProperties(List<IProperty<?>> properties, RegistryAccess access) {
        return ComplexProgressHandler.withProperties(0, properties, access);
    }

    public static ComplexProgressHandler withProperties(final int offset, final List<IProperty<?>> properties, final RegistryAccess access) {
        RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.buffer((int)32), access);
        for (IProperty<?> property : properties) {
            property.write(buf);
        }
        final int cSize = buf.writerIndex();
        return new ComplexProgressHandler(){

            @Override
            public ComplexProgressManager create() {
                ComplexProgressManager cpm = new ComplexProgressManager(cSize, offset);
                for (int i = 0; i < properties.size(); ++i) {
                    cpm.registerProperty("p" + i, (IProperty)properties.get(i));
                }
                return cpm;
            }

            @Override
            public void update(ComplexProgressManager manager) {
                RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.buffer((int)32), access);
                for (IProperty property : properties) {
                    property.write(buf);
                }
                manager.putBytes(0, buf.array(), 0, buf.writerIndex());
            }

            @Override
            public void containerTick(ComplexProgressManager manager) {
                RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.wrappedBuffer((byte[])manager.getBytes()), access);
                for (IProperty property : properties) {
                    property.read(buf);
                }
            }
        };
    }
}

