/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.entity;

import com.mrcrayfish.framework.api.sync.DataSerializer;
import com.mrcrayfish.framework.api.sync.Serializers;
import com.mrcrayfish.framework.api.sync.SyncedClassKey;
import com.mrcrayfish.framework.api.sync.SyncedDataKey;
import com.mrcrayfish.furniture.refurbished.core.ModEntities;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Seat
extends Entity {
    public static final SyncedClassKey<Seat> SEAT = new SyncedClassKey(Seat.class, Utils.resource("seat"));
    public static final SyncedDataKey<Seat, Boolean> LOCK_YAW = SyncedDataKey.builder(SEAT, (DataSerializer)Serializers.BOOLEAN).id(Utils.resource("lock_yaw")).defaultValueSupplier(() -> false).syncMode(SyncedDataKey.SyncMode.TRACKING_ONLY).saveToFile().build();

    public Seat(Level level) {
        super((EntityType)ModEntities.SEAT.get(), level);
    }

    private Seat(Level level, BlockPos pos, double seatHeight, float seatYaw, boolean lockYaw) {
        this(level);
        this.setPos(Vec3.atBottomCenterOf((Vec3i)pos).add(0.0, seatHeight, 0.0));
        this.setRot(seatYaw, 0.0f);
        LOCK_YAW.setValue((Entity)this, (Object)lockYaw);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        Level level = this.level();
        if (!level.isClientSide()) {
            BlockPos pos = this.blockPosition();
            if (this.getPassengers().isEmpty() || level.isEmptyBlock(pos)) {
                this.discard();
                level.updateNeighbourForOutputSignal(pos, level.getBlockState(pos).getBlock());
            }
        }
    }

    protected void addPassenger(Entity entity) {
        super.addPassenger(entity);
        entity.setYRot(this.getYRot());
    }

    public void onPassengerTurned(Entity entity) {
        this.clampPassengerYaw(entity);
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity entity) {
        Direction[] sides;
        Direction front = (Boolean)LOCK_YAW.getValue((Entity)this) != false ? this.getDirection() : entity.getDirection();
        for (Direction side : sides = new Direction[]{front, front.getClockWise(), front.getCounterClockWise(), front.getOpposite()}) {
            Vec3 pos = DismountHelper.findSafeDismountLocation((EntityType)entity.getType(), (CollisionGetter)this.level(), (BlockPos)this.blockPosition().relative(side), (boolean)false);
            if (pos == null) continue;
            return pos.add(0.0, 0.25, 0.0);
        }
        return super.getDismountLocationForPassenger(entity);
    }

    private void clampPassengerYaw(Entity entity) {
        if (((Boolean)LOCK_YAW.getValue((Entity)this)).booleanValue()) {
            entity.setYBodyRot(this.getYRot());
            float wrappedYaw = Mth.wrapDegrees((float)(entity.getYRot() - this.getYRot()));
            float clampedYaw = Mth.clamp((float)wrappedYaw, (float)-120.0f, (float)120.0f);
            entity.yRotO += clampedYaw - wrappedYaw;
            entity.setYRot(entity.getYRot() + clampedYaw - wrappedYaw);
            entity.setYHeadRot(entity.getYRot());
        }
    }

    public static boolean sit(Player player, BlockPos pos, double seatHeight, @Nullable Direction direction) {
        Level level = player.level();
        if (!level.isClientSide() && Seat.availableAt(level, pos)) {
            float seatYaw = direction != null ? direction.toYRot() : player.getYRot();
            Seat seat = new Seat(level, pos, seatHeight, seatYaw, direction != null);
            level.addFreshEntity((Entity)seat);
            return player.startRiding((Entity)seat);
        }
        return false;
    }

    public static boolean availableAt(Level level, BlockPos pos) {
        return level.getEntitiesOfClass(Seat.class, new AABB(pos)).isEmpty();
    }
}

