/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import java.util.Objects;

public record CollectionStatistics(String field, long maxDoc, long docCount, long sumTotalTermFreq, long sumDocFreq) {
    public CollectionStatistics {
        Objects.requireNonNull(field);
        if (maxDoc <= 0L) {
            throw new IllegalArgumentException("maxDoc must be positive, maxDoc: " + maxDoc);
        }
        if (docCount <= 0L) {
            throw new IllegalArgumentException("docCount must be positive, docCount: " + docCount);
        }
        if (docCount > maxDoc) {
            throw new IllegalArgumentException("docCount must not exceed maxDoc, docCount: " + docCount + ", maxDoc: " + maxDoc);
        }
        if (sumDocFreq <= 0L) {
            throw new IllegalArgumentException("sumDocFreq must be positive, sumDocFreq: " + sumDocFreq);
        }
        if (sumDocFreq < docCount) {
            throw new IllegalArgumentException("sumDocFreq must be at least docCount, sumDocFreq: " + sumDocFreq + ", docCount: " + docCount);
        }
        if (sumTotalTermFreq <= 0L) {
            throw new IllegalArgumentException("sumTotalTermFreq must be positive, sumTotalTermFreq: " + sumTotalTermFreq);
        }
        if (sumTotalTermFreq < sumDocFreq) {
            throw new IllegalArgumentException("sumTotalTermFreq must be at least sumDocFreq, sumTotalTermFreq: " + sumTotalTermFreq + ", sumDocFreq: " + sumDocFreq);
        }
    }
}

