/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.miscellaneous;

import guideme.internal.shaded.lucene.analysis.TokenFilterFactory;
import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.miscellaneous.LimitTokenCountFilter;
import java.util.Map;

public class LimitTokenCountFilterFactory
extends TokenFilterFactory {
    public static final String NAME = "limitTokenCount";
    public static final String MAX_TOKEN_COUNT_KEY = "maxTokenCount";
    public static final String CONSUME_ALL_TOKENS_KEY = "consumeAllTokens";
    final int maxTokenCount;
    final boolean consumeAllTokens;

    public LimitTokenCountFilterFactory(Map<String, String> args) {
        super(args);
        this.maxTokenCount = this.requireInt(args, MAX_TOKEN_COUNT_KEY);
        this.consumeAllTokens = this.getBoolean(args, CONSUME_ALL_TOKENS_KEY, false);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + String.valueOf(args));
        }
    }

    public LimitTokenCountFilterFactory() {
        throw LimitTokenCountFilterFactory.defaultCtorException();
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new LimitTokenCountFilter(input, this.maxTokenCount, this.consumeAllTokens);
    }
}

