/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.panels;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import org.zeith.solarflux.api.INBTSerializable;
import org.zeith.solarflux.api.ISolarPanelTile;
import org.zeith.solarflux.init.SolarPanelsSF;
import org.zeith.solarflux.panels.SolarPanel;

public class SolarPanelInstance
implements INBTSerializable {
    public SolarPanel infoDelegate;
    public String delegate;
    public long gen;
    public long cap;
    public long transfer;
    public boolean valid = false;

    public SolarPanel getDelegate() {
        if (this.infoDelegate == null) {
            this.infoDelegate = SolarPanelsSF.PANELS.get(this.delegate);
            return this.infoDelegate;
        }
        return this.infoDelegate;
    }

    public float computeSunIntensity(ISolarPanelTile solar) {
        if (this.getDelegate() != null) {
            return this.infoDelegate.computeSunIntensity(solar);
        }
        if (!solar.doesSeeSky()) {
            return 0.0f;
        }
        float celestialAngleRadians = solar.level().getSunAngle(1.0f);
        if ((double)celestialAngleRadians > Math.PI) {
            celestialAngleRadians = (float)(Math.PI * 2 - (double)celestialAngleRadians);
        }
        boolean lowLightCount = false;
        float multiplicator = 1.5f - (float)lowLightCount * 0.122f;
        float displacement = 1.2f + (float)lowLightCount * 0.08f;
        return Mth.clamp((float)(multiplicator * Mth.cos((float)(celestialAngleRadians / displacement))), (float)0.0f, (float)1.0f);
    }

    public boolean isValid() {
        return this.valid;
    }

    public void reset() {
        SolarPanel info = this.getDelegate();
        boolean bl = this.valid = info != null;
        if (this.valid) {
            info.accept(this);
        }
    }

    public static SolarPanelInstance deserialize(CompoundTag nbt) {
        SolarPanelInstance inst = new SolarPanelInstance();
        inst.deserializeNBT(nbt);
        return inst;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.putString("Delegate", this.delegate.toString());
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.delegate = nbt.getString("Delegate");
        this.reset();
    }
}

