/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.items.upgrades;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.zeith.hammerlib.api.inv.SimpleInventory;
import org.zeith.hammerlib.api.items.coms.CustomGlintComponent;
import org.zeith.hammerlib.core.init.ComponentTypesHL;
import org.zeith.solarflux.api.IFurnaceBlockEntity;
import org.zeith.solarflux.api.ISolarPanelTile;
import org.zeith.solarflux.init.ItemsSF;
import org.zeith.solarflux.init.SolarPanelsSF;
import org.zeith.solarflux.items.data.GlobalFaceComponent;
import org.zeith.solarflux.items.upgrades.ItemTraversalUpgrade;
import org.zeith.solarflux.items.upgrades._base.UpgradeItem;
import org.zeith.solarflux.util.BlockPosFace;

public class ItemBlockChargingUpgrade
extends UpgradeItem {
    public ItemBlockChargingUpgrade() {
        super(new Item.Properties().stacksTo(1).component(GlobalFaceComponent.TYPE, null).component((Supplier)ComponentTypesHL.CUSTOM_GLINT, (Object)CustomGlintComponent.fixedColor((int)-15597790)));
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, worldIn, tooltip, flagIn);
        GlobalFaceComponent face = (GlobalFaceComponent)stack.get((DataComponentType)GlobalFaceComponent.TYPE.get());
        if (face == null) {
            return;
        }
        tooltip.add((Component)Component.literal((String)("Dimension: " + String.valueOf(face.pos().dimension().location()))));
        tooltip.add((Component)Component.literal((String)("Facing: " + face.dir().getName())));
        BlockPos pos = face.pos().pos();
        tooltip.add((Component)Component.literal((String)("X: " + pos.getX() + ", Y: " + pos.getY() + ", Z: " + pos.getZ())));
    }

    public InteractionResult useOn(UseOnContext context) {
        IEnergyStorage estorage;
        BlockPos pos;
        Level level = context.getLevel();
        BlockEntity tile = level.getBlockEntity(pos = context.getClickedPos());
        if (tile instanceof IFurnaceBlockEntity) {
            IFurnaceBlockEntity furnace = (IFurnaceBlockEntity)tile;
            if (context.getClickedFace() == furnace.getSideForSolarPanel()) {
                ItemStack held = context.getItemInHand();
                held.set((DataComponentType)GlobalFaceComponent.TYPE.get(), (Object)new GlobalFaceComponent(GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)pos), context.getClickedFace()));
                level.playSound(null, pos, SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS, 0.25f, 1.8f);
                return InteractionResult.SUCCESS;
            }
        }
        if ((estorage = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, pos, (Object)context.getClickedFace())) != null && estorage.canReceive()) {
            ItemStack held = context.getItemInHand();
            held.set((DataComponentType)GlobalFaceComponent.TYPE.get(), (Object)new GlobalFaceComponent(GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)pos), context.getClickedFace()));
            level.playSound(null, pos, SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS, 0.25f, 1.8f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public boolean isFoil(ItemStack stack) {
        return stack.has((DataComponentType)GlobalFaceComponent.TYPE.get());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canInstall(ISolarPanelTile tile, ItemStack stack, SimpleInventory upgradeInv) {
        BlockPos blockPos;
        GlobalFaceComponent face = (GlobalFaceComponent)stack.get((DataComponentType)GlobalFaceComponent.TYPE.get());
        if (face == null) return false;
        if (!tile.level().dimension().equals(face.pos().dimension())) return false;
        BlockPos pos = face.pos().pos();
        if (!(tile.pos().distSqr((Vec3i)blockPos) <= (double)SolarPanelsSF.BLOCK_CHARGING_UPGRADE_RANGE)) return false;
        if (tile.level().getCapability(Capabilities.EnergyStorage.BLOCK, pos, (Object)face.dir()) != null) return true;
        BlockEntity blockEntity = tile.level().getBlockEntity(pos);
        if (!(blockEntity instanceof IFurnaceBlockEntity)) return false;
        IFurnaceBlockEntity furnace = (IFurnaceBlockEntity)blockEntity;
        if (face.dir() != furnace.getSideForSolarPanel()) return false;
        if (tile.getUpgrades(ItemsSF.FURNACE_UPGRADE) <= 0) return false;
        return true;
    }

    @Override
    public boolean canStayInPanel(ISolarPanelTile tile, ItemStack stack, SimpleInventory upgradeInv) {
        return this.canInstall(tile, stack, upgradeInv);
    }

    @Override
    public void update(ISolarPanelTile tile, ItemStack stack, int amount) {
        double d;
        GlobalFaceComponent face = (GlobalFaceComponent)stack.get((DataComponentType)GlobalFaceComponent.TYPE.get());
        if (face == null || tile.level().getDayTime() % 20L != 0L) {
            return;
        }
        BlockPos pos = face.pos().pos();
        double d2 = tile.pos().distSqr((Vec3i)pos);
        if (d <= (double)SolarPanelsSF.BLOCK_CHARGING_UPGRADE_RANGE) {
            d2 /= (double)SolarPanelsSF.BLOCK_CHARGING_UPGRADE_RANGE;
            tile.traversal().clear();
            if (tile.getUpgrades(ItemsSF.TRAVERSAL_UPGRADE) > 0) {
                ItemTraversalUpgrade.cache.clear();
                ItemTraversalUpgrade.cache.add(pos);
                ItemTraversalUpgrade.findMachines(tile, ItemTraversalUpgrade.cache, tile.traversal());
            }
            tile.traversal().add(new BlockPosFace(pos, face.dir(), (float)(1.0 - d2)));
        }
    }

    @Override
    protected Object[] hoverTextData(ItemStack stack) {
        return new Object[]{Math.round((float)Math.sqrt(SolarPanelsSF.BLOCK_CHARGING_UPGRADE_RANGE))};
    }
}

