/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.compat.twilightforest.items;

import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import org.zeith.hammerlib.api.inv.SimpleInventory;
import org.zeith.hammerlib.compat.base.Ability;
import org.zeith.hammerlib.util.mcf.Resources;
import org.zeith.solarflux.api.ISolarPanelTile;
import org.zeith.solarflux.items.upgrades._base.ISunIntensityMod;
import org.zeith.solarflux.items.upgrades._base.UpgradeItem;

public class TwiLightUpgrade
extends UpgradeItem
implements ISunIntensityMod {
    public static final ResourceKey<DimensionType> TWILIGHT_DIM_TYPE = ResourceKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)Resources.location((String)"twilightforest", (String)"twilight_forest_type"));

    public TwiLightUpgrade() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.RARE));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isTwilight(Level level) {
        if (level == null) return false;
        if (level.dimensionTypeRegistration().unwrapKey().map(TWILIGHT_DIM_TYPE::equals).orElse(false) == false) return false;
        return true;
    }

    @Override
    public float applySunIntensityModifier(ISolarPanelTile tile, float value) {
        if (tile.doesSeeSky() && TwiLightUpgrade.isTwilight(tile.level())) {
            return 0.45f;
        }
        return value;
    }

    @Override
    public boolean canInstall(ISolarPanelTile tile, ItemStack stack, SimpleInventory upgradeInv) {
        return TwiLightUpgrade.isTwilight(tile.level()) && super.canInstall(tile, stack, upgradeInv);
    }

    @Override
    public boolean canStayInPanel(ISolarPanelTile tile, ItemStack stack, SimpleInventory upgradeInv) {
        return TwiLightUpgrade.isTwilight(tile.level()) && super.canStayInPanel(tile, stack, upgradeInv);
    }

    @Override
    public <T> Optional<T> findAbility(Ability<T> ability) {
        return ability.findIn(new Object[]{this}).or(() -> super.findAbility(ability));
    }
}

