/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.client;

import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BooleanSupplier;
import net.minecraft.SharedConstants;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.util.mcf.Resources;
import org.zeith.hammerlib.util.shaded.json.JSONObject;
import org.zeith.solarflux.block.SolarPanelBlock;
import org.zeith.solarflux.init.SolarPanelsSF;
import org.zeith.solarflux.panels.JSHelper;

public class SolarFluxResourcePack
implements PackResources {
    public static boolean canInit = false;
    public final Map<ResourceLocation, IResourceStreamSupplier> resourceMap = new HashMap<ResourceLocation, IResourceStreamSupplier>();
    static SolarFluxResourcePack packInstance;
    private boolean hasInit = false;
    protected final PackLocationInfo loca = new PackLocationInfo(this.packId(), (Component)Component.literal((String)this.packId()), PackSource.BUILT_IN, Optional.empty());

    private static IResourceStreamSupplier ofText(String text) {
        return IResourceStreamSupplier.create(() -> true, () -> new ByteArrayInputStream(text.getBytes()));
    }

    private static IResourceStreamSupplier ofFile(File file) {
        return IResourceStreamSupplier.create(file::isFile, () -> new FileInputStream(file));
    }

    private static IResourceStreamSupplier oneOfFiles(File ... file) {
        return IResourceStreamSupplier.create(() -> Arrays.stream(file).anyMatch(File::isFile), () -> new FileInputStream(Arrays.stream(file).filter(File::isFile).findFirst().orElseThrow(FileNotFoundException::new)));
    }

    public static SolarFluxResourcePack getPackInstance() {
        if (packInstance == null) {
            packInstance = new SolarFluxResourcePack();
        }
        return packInstance;
    }

    public void init() {
        if (this.hasInit || !canInit) {
            return;
        }
        this.hasInit = true;
        this.resourceMap.clear();
        File textures = new File(SolarPanelsSF.CONFIG_DIR, "textures");
        JSHelper.JS_MATERIALS.forEach(i -> {
            ResourceLocation reg = i.getRegistryName();
            ResourceLocation models_item = Resources.location((String)reg.getNamespace(), (String)("models/item/" + reg.getPath() + ".json"));
            this.resourceMap.put(models_item, SolarFluxResourcePack.ofText("{\"parent\":\"item/generated\",\"textures\":{\"layer0\":\"" + reg.getNamespace() + ":item/materials/" + reg.getPath() + "\"}}"));
            File items = new File(textures, "item");
            ResourceLocation textures_items = Resources.location((String)reg.getNamespace(), (String)("textures/item/materials/" + reg.getPath() + ".png"));
            this.resourceMap.put(textures_items, SolarFluxResourcePack.ofFile(new File(items, reg.getPath() + ".png")));
        });
        SolarPanelsSF.listPanels().forEach(si -> {
            SolarPanelBlock blk = si.getBlock();
            ResourceLocation reg = BuiltInRegistries.BLOCK.getKey((Object)blk);
            ResourceLocation blockstate = Resources.location((String)reg.getNamespace(), (String)("blockstates/" + reg.getPath() + ".json"));
            ResourceLocation models_block = Resources.location((String)reg.getNamespace(), (String)("models/block/" + reg.getPath() + ".json"));
            ResourceLocation models_item = Resources.location((String)reg.getNamespace(), (String)("models/item/" + reg.getPath() + ".json"));
            this.resourceMap.put(blockstate, SolarFluxResourcePack.ofText("{\"variants\":{\"\":{\"model\":\"" + reg.getNamespace() + ":block/" + reg.getPath() + "\"}}}"));
            this.resourceMap.put(models_item, SolarFluxResourcePack.ofText("{\"parent\":\"" + reg.getNamespace() + ":block/" + reg.getPath() + "\"}"));
            JSONObject blockModel = new JSONObject();
            blockModel.put("loader", (Object)"solarflux:solar_panel");
            blockModel.put("panel", (Object)reg.toString());
            this.resourceMap.put(models_block, SolarFluxResourcePack.ofText(blockModel.toString()));
            if (si.isCustom) {
                File blocks = new File(textures, "block");
                ResourceLocation textures_blocks_base = Resources.location((String)reg.getNamespace(), (String)("textures/block/" + reg.getPath() + "_base.png"));
                ResourceLocation textures_blocks_top = Resources.location((String)reg.getNamespace(), (String)("textures/block/" + reg.getPath() + "_top.png"));
                ResourceLocation textures_blocks_base_mcmeta = Resources.location((String)reg.getNamespace(), (String)("textures/block/" + reg.getPath() + "_base.png.mcmeta"));
                ResourceLocation textures_blocks_top_mcmeta = Resources.location((String)reg.getNamespace(), (String)("textures/block/" + reg.getPath() + "_top.png.mcmeta"));
                String n = reg.getPath().startsWith("sp_custom_") ? reg.getPath().substring(10) : reg.getPath().substring(3);
                this.resourceMap.put(textures_blocks_base, SolarFluxResourcePack.ofFile(new File(blocks, n + "_base.png")));
                this.resourceMap.put(textures_blocks_base_mcmeta, SolarFluxResourcePack.oneOfFiles(new File(blocks, n + "_base.mcmeta"), new File(blocks, n + "_base.png.mcmeta")));
                this.resourceMap.put(textures_blocks_top, SolarFluxResourcePack.ofFile(new File(blocks, n + "_top.png")));
                this.resourceMap.put(textures_blocks_top_mcmeta, SolarFluxResourcePack.oneOfFiles(new File(blocks, n + "_top.mcmeta"), new File(blocks, n + "_top.png.mcmeta")));
            }
        });
    }

    public void close() {
    }

    public boolean isHidden() {
        return true;
    }

    @Nullable
    public IoSupplier<InputStream> getRootResource(String ... path) {
        return null;
    }

    public IoSupplier<InputStream> getResource(PackType type, ResourceLocation location) {
        IResourceStreamSupplier res = this.resourceMap.get(location);
        if (res == null) {
            return null;
        }
        if (!res.exists()) {
            return null;
        }
        return () -> {
            try {
                this.init();
                return res.create();
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        };
    }

    public void listResources(PackType type, String namespace, String dir, PackResources.ResourceOutput out) {
        if (!namespace.equals("solarflux")) {
            return;
        }
        this.init();
        for (Map.Entry<ResourceLocation, IResourceStreamSupplier> e : this.resourceMap.entrySet()) {
            if (!e.getKey().getPath().startsWith(dir) || !e.getValue().exists()) continue;
            out.accept((Object)e.getKey(), e.getValue()::create);
        }
    }

    public Set<String> getNamespaces(PackType type) {
        this.init();
        return Collections.singleton("solarflux");
    }

    public <T> T getMetadataSection(MetadataSectionSerializer<T> deserializer) throws IOException {
        if (deserializer.getMetadataSectionName().equals("pack")) {
            JsonObject obj = new JsonObject();
            obj.addProperty("pack_format", (Number)SharedConstants.getCurrentVersion().getPackVersion(PackType.CLIENT_RESOURCES));
            obj.addProperty("description", "Generated resources for SolarFlux");
            return (T)deserializer.fromJson(obj);
        }
        return null;
    }

    public PackLocationInfo location() {
        return this.loca;
    }

    public String packId() {
        return "SolarFlux";
    }

    @FunctionalInterface
    public static interface IIOSupplier<T> {
        public T get() throws IOException;
    }

    public static interface IResourceStreamSupplier {
        public static IResourceStreamSupplier create(final BooleanSupplier exists, final IIOSupplier<InputStream> streamable) {
            return new IResourceStreamSupplier(){

                @Override
                public boolean exists() {
                    return exists.getAsBoolean();
                }

                @Override
                public InputStream create() throws IOException {
                    return (InputStream)streamable.get();
                }
            };
        }

        public boolean exists();

        public InputStream create() throws IOException;
    }
}

