/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.block;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.zeith.hammerlib.api.items.ITabItem;
import org.zeith.solarflux.SolarFlux;
import org.zeith.solarflux.block.SolarPanelBlock;
import org.zeith.solarflux.items.data.PanelDataComponent;

public class SolarPanelBlockItem
extends BlockItem
implements ITabItem {
    public final SolarPanelBlock panelBlock;

    public SolarPanelBlockItem(SolarPanelBlock blockIn, Item.Properties builder) {
        super((Block)blockIn, builder.component((DataComponentType)PanelDataComponent.TYPE.get(), (Object)PanelDataComponent.EMPTY));
        this.panelBlock = blockIn;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.literal((String)I18n.get((String)"info.solarflux.energy.generation", (Object[])new Object[]{this.panelBlock.panel.getPanelData().generation})).withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.literal((String)I18n.get((String)"info.solarflux.energy.transfer", (Object[])new Object[]{this.panelBlock.panel.getPanelData().transfer})).withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.literal((String)I18n.get((String)"info.solarflux.energy.capacity", (Object[])new Object[]{this.panelBlock.panel.getPanelData().capacity})).withStyle(ChatFormatting.GRAY));
        PanelDataComponent com = (PanelDataComponent)stack.get((DataComponentType)PanelDataComponent.TYPE.get());
        if (com == null || com.isEmpty()) {
            return;
        }
        tooltip.add((Component)Component.literal((String)I18n.get((String)"info.solarflux.contentretained", (Object[])new Object[0])).withStyle(s -> s.withItalic(Boolean.valueOf(true)).withColor(39860)));
        tooltip.add((Component)Component.literal((String)I18n.get((String)"info.solarflux.resetcontent", (Object[])new Object[0])).withStyle(s -> s.withItalic(Boolean.valueOf(true)).withColor(120775)));
        if (Screen.hasShiftDown()) {
            if (com.energy() > 0L) {
                tooltip.add((Component)Component.literal((String)I18n.get((String)"info.solarflux.energy.stored1", (Object[])new Object[]{com.energy()})).withStyle(ChatFormatting.YELLOW));
            }
            boolean empty = true;
            for (ItemStack uStack2 : com.upgrades()) {
                if (uStack2.isEmpty()) continue;
                empty = false;
                break;
            }
            if (!empty) {
                tooltip.add((Component)Component.literal((String)(I18n.get((String)"info.solarflux.upgrades.installed", (Object[])new Object[0]) + ":")).withStyle(ChatFormatting.GRAY));
                com.upgrades().stream().filter(s -> !s.isEmpty()).mapMulti((uStack, line) -> {
                    List comps = uStack.getTooltipLines(context, (Player)Minecraft.getInstance().player, flagIn);
                    if (comps.isEmpty()) {
                        return;
                    }
                    line.accept(Component.literal((String)" - ").append((Component)((Component)comps.getFirst()).copy().append(" x" + uStack.getCount()).withStyle(ChatFormatting.GRAY)).withStyle(ChatFormatting.DARK_GRAY));
                    for (int i = 1; i < comps.size(); ++i) {
                        line.accept(Component.literal((String)"    ").append((Component)comps.get(i)).withStyle(ChatFormatting.DARK_GRAY));
                    }
                }).forEach(tooltip::add);
            }
        } else {
            tooltip.add((Component)Component.literal((String)I18n.get((String)"info.solarflux.hold.for.info", (Object[])new Object[]{String.valueOf(ChatFormatting.YELLOW) + I18n.get((String)"info.solarflux.shift", (Object[])new Object[0]) + String.valueOf(ChatFormatting.DARK_GRAY)})).withStyle(ChatFormatting.DARK_GRAY));
        }
    }

    public CreativeModeTab getItemCategory() {
        return SolarFlux.ITEM_GROUP.tab();
    }
}

